/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.action.NumberVerifyListener;
import com.clustercontrol.composite.action.StringVerifyListener;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.repository.FacilityPath;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobCommandInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommandComposite
extends Composite {
    private Text m_scope = null;
    private Text m_startCommand = null;
    private Button m_executeStopCommand;
    private Text m_stopCommand = null;
    private Button m_destroyProcess;
    private Button m_agentUser = null;
    private Button m_specifyUser = null;
    private Text m_user = null;
    private Button m_scopeJobParam = null;
    private Button m_scopeFixedValue = null;
    private Button m_scopeSelect = null;
    private Button m_allNode = null;
    private Button m_retry = null;
    private Button m_errorCondition = null;
    private Text m_errorEndValue = null;
    private Group m_errorEndConditionGroup = null;
    private Text m_messageRetry;
    private String m_facilityId = null;
    private String m_facilityPath = null;
    private JobCommandInfo m_execute = null;
    private Shell m_shell = null;
    private String m_ownerRoleId = null;

    public CommandComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        Label label = null;
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"scope"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_scopeJobParam = new Button(composite, 16);
        this.m_scopeJobParam.setText(String.valueOf(Messages.getString((String)"job.parameter")) + " : ");
        this.m_scopeJobParam.setLayoutData((Object)new RowData(120, 22));
        this.m_scopeJobParam.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_scopeFixedValue.setSelection(false);
                    CommandComposite.this.m_scopeSelect.setEnabled(false);
                }
                CommandComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(composite, 16384);
        label.setText(SystemParameterConstant.getParamText((String)"FACILITY_ID"));
        label.setLayoutData((Object)new RowData(100, 15));
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_scopeFixedValue = new Button(composite, 16);
        this.m_scopeFixedValue.setText(String.valueOf(Messages.getString((String)"fixed.value")) + " : ");
        this.m_scopeFixedValue.setLayoutData((Object)new RowData(120, 22));
        this.m_scopeFixedValue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_scopeJobParam.setSelection(false);
                    CommandComposite.this.m_scopeSelect.setEnabled(true);
                }
                CommandComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_scope = new Text(composite, 2056);
        this.m_scope.setLayoutData((Object)new RowData(200, 15));
        this.m_scope.setText("");
        this.m_scope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CommandComposite.this.update();
            }
        });
        this.m_scopeSelect = new Button(composite, 0);
        this.m_scopeSelect.setText(Messages.getString((String)"refer"));
        this.m_scopeSelect.setLayoutData((Object)new RowData(80, 22));
        this.m_scopeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(CommandComposite.this.m_shell, CommandComposite.this.m_ownerRoleId);
                if (dialog.open() == 0) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    FacilityInfo info = selectItem.getData();
                    FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                    CommandComposite.this.m_facilityPath = path.getPath(selectItem);
                    CommandComposite.this.m_facilityId = info.getFacilityId();
                    CommandComposite.this.m_scope.setText(CommandComposite.this.m_facilityPath);
                    CommandComposite.this.update();
                }
            }
        });
        group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"scope.process"));
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        this.m_allNode = new Button((Composite)group, 16);
        this.m_allNode.setText(Messages.getString((String)"scope.process.all.nodes"));
        this.m_allNode.setLayoutData((Object)new RowData(200, 22));
        this.m_retry = new Button((Composite)group, 16);
        this.m_retry.setText(Messages.getString((String)"scope.process.retry.nodes"));
        this.m_retry.setLayoutData((Object)new RowData(300, 22));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"start.command")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_startCommand = new Text(composite, 2048);
        this.m_startCommand.setLayoutData((Object)new RowData(400, 15));
        this.m_startCommand.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        this.m_startCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CommandComposite.this.update();
            }
        });
        group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"stop"));
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_destroyProcess = new Button(composite, 16);
        this.m_destroyProcess.setText(Messages.getString((String)"shutdown.process"));
        this.m_destroyProcess.setLayoutData((Object)new RowData(190, 22));
        this.m_destroyProcess.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_executeStopCommand.setSelection(false);
                    CommandComposite.this.m_stopCommand.setEnabled(false);
                }
                CommandComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_executeStopCommand = new Button(composite, 16);
        this.m_executeStopCommand.setText(Messages.getString((String)"stop.command"));
        this.m_executeStopCommand.setLayoutData((Object)new RowData(120, 22));
        this.m_executeStopCommand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_destroyProcess.setSelection(false);
                    CommandComposite.this.m_stopCommand.setEnabled(true);
                }
                CommandComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_stopCommand = new Text(composite, 2048);
        this.m_stopCommand.setLayoutData((Object)new RowData(160, 15));
        this.m_stopCommand.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        this.m_stopCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CommandComposite.this.update();
            }
        });
        group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"effective.user"));
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_agentUser = new Button(composite, 16);
        this.m_agentUser.setText(Messages.getString((String)"agent.user"));
        this.m_agentUser.setLayoutData((Object)new RowData(190, 22));
        this.m_agentUser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_specifyUser.setSelection(false);
                    CommandComposite.this.m_user.setEnabled(false);
                }
                CommandComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_specifyUser = new Button(composite, 16);
        this.m_specifyUser.setText(Messages.getString((String)"specified.user"));
        this.m_specifyUser.setLayoutData((Object)new RowData(120, 22));
        this.m_specifyUser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_agentUser.setSelection(false);
                    CommandComposite.this.m_user.setEnabled(true);
                }
                CommandComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_user = new Text(composite, 2048);
        this.m_user.setLayoutData((Object)new RowData(160, 15));
        this.m_user.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        this.m_user.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CommandComposite.this.update();
            }
        });
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_errorCondition = new Button(composite, 32);
        this.m_errorCondition.setText(Messages.getString((String)"command.error.ended"));
        this.m_errorCondition.setLayoutData((Object)new RowData(300, 22));
        this.m_errorCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    CommandComposite.this.m_errorEndConditionGroup.setEnabled(true);
                    CommandComposite.this.m_errorEndValue.setEnabled(true);
                    CommandComposite.this.m_messageRetry.setEnabled(true);
                } else {
                    CommandComposite.this.m_errorEndConditionGroup.setEnabled(false);
                    CommandComposite.this.m_errorEndValue.setEnabled(false);
                    CommandComposite.this.m_messageRetry.setEnabled(false);
                }
                CommandComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_errorEndConditionGroup = new Group((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        rowLayout.spacing = 10;
        this.m_errorEndConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_errorEndConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label messageRetryTitle = new Label(composite, 16384);
        messageRetryTitle.setText(String.valueOf(Messages.getString((String)"job.retries")) + " : ");
        messageRetryTitle.setLayoutData((Object)new RowData(90, 15));
        this.m_messageRetry = new Text(composite, 2048);
        this.m_messageRetry.setLayoutData((Object)new RowData(100, 15));
        this.m_messageRetry.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_messageRetry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CommandComposite.this.update();
            }
        });
        composite = new Composite((Composite)this.m_errorEndConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label skipEndValueTitle = new Label(composite, 131072);
        skipEndValueTitle.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        skipEndValueTitle.setLayoutData((Object)new RowData(70, 15));
        this.m_errorEndValue = new Text(composite, 2048);
        this.m_errorEndValue.setLayoutData((Object)new RowData(100, 15));
        this.m_errorEndValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_errorEndValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CommandComposite.this.update();
            }
        });
    }

    public void update() {
        if (this.m_scopeFixedValue.getSelection() && "".equals(this.m_scope.getText())) {
            this.m_scope.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_scope.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_startCommand.getText())) {
            this.m_startCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_startCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_executeStopCommand.getSelection() && "".equals(this.m_stopCommand.getText())) {
            this.m_stopCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_stopCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_specifyUser.getSelection() && "".equals(this.m_user.getText())) {
            this.m_user.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_user.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_errorCondition.getSelection() && "".equals(this.m_errorEndValue.getText())) {
            this.m_errorEndValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_errorEndValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_messageRetry.getText())) {
            this.m_messageRetry.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_messageRetry.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void reflectCommandInfo() {
        this.m_scopeJobParam.setSelection(false);
        this.m_scopeFixedValue.setSelection(true);
        this.m_scope.setText("");
        this.m_allNode.setSelection(true);
        this.m_startCommand.setText("");
        this.m_executeStopCommand.setSelection(false);
        this.m_destroyProcess.setSelection(true);
        this.m_stopCommand.setText("");
        this.m_stopCommand.setEnabled(false);
        this.m_agentUser.setSelection(true);
        this.m_specifyUser.setSelection(false);
        this.m_user.setText("");
        this.m_user.setEnabled(false);
        this.m_messageRetry.setText("10");
        this.m_errorCondition.setSelection(true);
        this.m_errorEndValue.setText(String.valueOf(-1));
        if (this.m_execute != null) {
            this.m_facilityPath = this.m_execute.getScope();
            this.m_facilityId = this.m_execute.getFacilityID();
            if (SystemParameterConstant.isParam((String)this.m_facilityId, (String)"FACILITY_ID")) {
                this.m_facilityId = "";
                this.m_facilityPath = "";
                this.m_scope.setText(this.m_facilityPath);
                this.m_scopeJobParam.setSelection(true);
                this.m_scopeFixedValue.setSelection(false);
            } else {
                if (this.m_facilityPath != null && this.m_facilityPath.length() > 0) {
                    this.m_scope.setText(this.m_facilityPath);
                }
                this.m_scopeJobParam.setSelection(false);
                this.m_scopeFixedValue.setSelection(true);
            }
            if (this.m_execute.getProcessingMethod() == 0) {
                this.m_allNode.setSelection(true);
                this.m_retry.setSelection(false);
            } else {
                this.m_allNode.setSelection(false);
                this.m_retry.setSelection(true);
            }
            if (this.m_execute.getStartCommand() != null && this.m_execute.getStartCommand().length() > 0) {
                this.m_startCommand.setText(this.m_execute.getStartCommand());
            }
            if (this.m_execute.getStopType() == 1) {
                this.m_destroyProcess.setSelection(true);
                this.m_executeStopCommand.setSelection(false);
            } else {
                this.m_destroyProcess.setSelection(false);
                this.m_executeStopCommand.setSelection(true);
                this.m_stopCommand.setEnabled(true);
            }
            if (this.m_execute.getStopCommand() != null && this.m_execute.getStopCommand().length() > 0) {
                this.m_stopCommand.setText(this.m_execute.getStopCommand());
            }
            if (this.m_execute.getSpecifyUser() == 1) {
                this.m_specifyUser.setSelection(true);
                this.m_agentUser.setSelection(false);
                this.m_user.setEnabled(true);
            } else {
                this.m_specifyUser.setSelection(false);
                this.m_agentUser.setSelection(true);
                this.m_user.setEnabled(false);
            }
            if (this.m_execute.getUser() != null && this.m_execute.getUser().length() > 0) {
                this.m_user.setText(this.m_execute.getUser());
            }
            this.m_messageRetry.setText(String.valueOf(this.m_execute.getMessageRetry()));
            this.m_errorCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_execute.getErrorEndFlg()));
            this.m_errorEndValue.setText(String.valueOf(this.m_execute.getErrorEndValue()));
        }
        if (this.m_scopeJobParam.getSelection()) {
            this.m_scopeSelect.setEnabled(false);
        } else {
            this.m_scopeSelect.setEnabled(true);
        }
        if (this.m_errorCondition.getSelection()) {
            this.m_errorEndValue.setEnabled(true);
            this.m_messageRetry.setEnabled(true);
        } else {
            this.m_errorEndValue.setEnabled(false);
            this.m_messageRetry.setEnabled(false);
        }
    }

    public void setCommandInfo(JobCommandInfo execute) {
        this.m_execute = execute;
    }

    public JobCommandInfo getCommandInfo() {
        return this.m_execute;
    }

    public ValidateResult createCommandInfo() {
        block21: {
            ValidateResult result = null;
            this.m_execute = new JobCommandInfo();
            if (this.m_scopeJobParam.getSelection()) {
                this.m_execute.setFacilityID(SystemParameterConstant.getParamText((String)"FACILITY_ID"));
                this.m_execute.setScope("");
            } else if (this.m_facilityId != null && this.m_facilityId.length() > 0) {
                this.m_execute.setFacilityID(this.m_facilityId);
                this.m_execute.setScope(this.m_facilityPath);
            } else {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.hinemos.3"));
                return result;
            }
            if (this.m_allNode.getSelection()) {
                this.m_execute.setProcessingMethod(Integer.valueOf(0));
            } else {
                this.m_execute.setProcessingMethod(Integer.valueOf(1));
            }
            if (this.m_startCommand.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.3"));
                return result;
            }
            this.m_execute.setStartCommand(this.m_startCommand.getText());
            if (this.m_destroyProcess.getSelection()) {
                this.m_execute.setStopType(Integer.valueOf(1));
            } else if (this.m_stopCommand.getText().length() > 0) {
                this.m_execute.setStopType(Integer.valueOf(0));
                this.m_execute.setStopCommand(this.m_stopCommand.getText());
            } else {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.4"));
                return result;
            }
            if (this.m_agentUser.getSelection()) {
                this.m_execute.setSpecifyUser(Integer.valueOf(0));
            } else if (this.m_user.getText().length() > 0) {
                this.m_execute.setSpecifyUser(Integer.valueOf(1));
                this.m_execute.setUser(this.m_user.getText());
            } else {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.5"));
                return result;
            }
            try {
                if (this.m_messageRetry.getText().length() <= 0) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.job.87"));
                    return result;
                }
                this.m_execute.setMessageRetry(Integer.valueOf(Integer.parseInt(this.m_messageRetry.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.87"));
                return result;
            }
            this.m_execute.setErrorEndFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_errorCondition.getSelection())));
            try {
                if (this.m_errorEndValue.getText().length() <= 0) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.job.21"));
                    return result;
                }
                this.m_execute.setErrorEndValue(Integer.valueOf(Integer.parseInt(this.m_errorEndValue.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_execute.getErrorEndValue() != 1) break block21;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.21"));
                return result;
            }
        }
        return null;
    }

    public void setOwnerRoleId(String ownerRoleId) {
        this.m_ownerRoleId = ownerRoleId;
        this.m_scope.setText("");
        this.m_facilityId = null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_scope.setEnabled(enabled);
        this.m_startCommand.setEnabled(enabled);
        this.m_executeStopCommand.setEnabled(enabled);
        this.m_stopCommand.setEditable(enabled);
        this.m_destroyProcess.setEnabled(enabled);
        this.m_agentUser.setEnabled(enabled);
        this.m_specifyUser.setEnabled(enabled);
        this.m_user.setEnabled(enabled);
        this.m_scopeJobParam.setEnabled(enabled);
        this.m_scopeFixedValue.setEnabled(enabled);
        this.m_scopeSelect.setEnabled(enabled);
        this.m_allNode.setEnabled(enabled);
        this.m_retry.setEnabled(enabled);
        this.m_errorCondition.setEnabled(enabled);
        this.m_errorEndValue.setEnabled(enabled);
        this.m_messageRetry.setEnabled(enabled);
    }
}

