/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.editor;

import com.clustercontrol.bean.Property;
import com.clustercontrol.editor.PropertyDefine;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;

public class IPv6PropertyDefine
extends PropertyDefine
implements Serializable {
    private static final long serialVersionUID = 3962737174668125479L;

    public IPv6PropertyDefine() {
        this.m_cellEditor = new TextCellEditor();
    }

    @Override
    public String getColumnText(Object value) {
        return value.toString();
    }

    @Override
    public Object getValue(Property element) {
        return element.getValue();
    }

    @Override
    public void modify(Property element, Object value) {
        boolean check = false;
        try {
            InetAddress address;
            if (((String)value).length() == 0) {
                check = true;
            }
            if ((address = Inet6Address.getByName((String)value)) instanceof Inet6Address) {
                check = true;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        if (check) {
            element.setValue(value);
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.repository.25"));
        }
    }

    @Override
    public void initEditer() {
    }
}

