/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite.action;

import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class RealNumberVerifyListener
implements VerifyListener {
    public static final String MINUS_CHAR = "-";
    public static final String DOT_CHAR = ".";
    public static final String EXP_CHAR_U = "E";
    public static final String EXP_CHAR_L = "e";
    private Double low;
    private Double high;

    public RealNumberVerifyListener() {
        this.low = null;
        this.high = null;
    }

    public RealNumberVerifyListener(double low, double high) {
        this.low = low;
        this.high = high;
    }

    public Double getHigh() {
        return this.high;
    }

    public void setHigh(Double high) {
        this.high = high;
    }

    public Double getLow() {
        return this.low;
    }

    public void setLow(Double low) {
        this.low = low;
    }

    public void verifyText(VerifyEvent e) {
        Text text = (Text)e.getSource();
        StringBuilder input = new StringBuilder(text.getText());
        if (e.keyCode == 0) {
            input.replace(e.start, e.end, e.text);
        } else if (e.character == '\b' || e.character == '\u007f') {
            input.delete(e.start, e.end);
        } else {
            input.replace(e.start, e.end, e.text);
        }
        if (e.text.length() == 1 && DOT_CHAR.indexOf(e.text) == 0) {
            if (!input.toString().matches("-?\\d+\\.?\\d*(E?|E-?)\\d*")) {
                e.doit = false;
            }
            return;
        }
        if (e.text.length() == 1 && MINUS_CHAR.indexOf(e.text) == 0) {
            if (!input.toString().matches("-?\\d*\\.?\\d*(E?|E-?)\\d*")) {
                e.doit = false;
            }
            return;
        }
        if (e.text.length() == 1 && EXP_CHAR_U.indexOf(e.text) == 0) {
            if (!input.toString().matches("-?\\d*\\.?\\d+(E?|E-?)\\d*")) {
                e.doit = false;
            }
            return;
        }
        if (input.toString().matches(MINUS_CHAR)) {
            return;
        }
        if (!input.toString().matches("-?(\\d*|\\d+\\.\\d+)(\\d*|E\\d+|E-\\d+)")) {
            e.doit = false;
            return;
        }
        this.checkRange(e, input.toString());
    }

    protected void checkRange(VerifyEvent e, String inputText) {
        try {
            if (inputText.length() == 0) {
                return;
            }
            if (this.low == null || this.high == null) {
                return;
            }
            Double input = Double.valueOf(inputText.toString());
            if (input.compareTo(this.low) < 0 || input.compareTo(this.high) > 0) {
                e.doit = false;
                Object[] args = new String[]{this.low.toString(), this.high.toString()};
                MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.hinemos.8", (Object[])args));
            }
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }
}

