/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.calendar.action.AddCalendar;
import com.clustercontrol.calendar.action.GetCalendar;
import com.clustercontrol.calendar.action.GetCalendarDetailTableDefine;
import com.clustercontrol.calendar.action.ModifyCalendar;
import com.clustercontrol.calendar.composite.CalendarDetailInfoComposite;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.DateTimeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarDetailInfo;
import com.clustercontrol.ws.calendar.CalendarInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CalendarDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(CalendarDialog.class);
    private String calendarId = "";
    private Long calTimeFrom = new Long(-1L);
    private Long calTimeTo = new Long(-1L);
    private int mode;
    private Text txtCalID = null;
    private Text txtCalName = null;
    private Text txtCalTimeFrom = null;
    private Text txtCalTimeTo = null;
    private CalendarInfo inputData = null;
    private CalendarDetailInfoComposite m_calendarDetailComposite = null;
    private RoleIdListComposite m_ownerRoleId = null;
    private String ownerRoleId = null;
    private Shell shell = null;
    private Group groupCal = null;
    private Group groupCalDetail = null;
    private Text txtCalDescription = null;
    private Button btnTimeFrom = null;
    private Button btnTimeTo = null;

    public CalendarDialog(Shell parent) {
        super(parent);
    }

    public CalendarDialog(Shell parent, String id, int mode) {
        super(parent);
        this.calendarId = id;
        this.mode = mode;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.shell = this.getShell();
        this.shell.setText(Messages.getString((String)"dialog.calendar.calendar.create.modify"));
        GridData gridData = new GridData();
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        this.groupCal = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        this.groupCal.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupCal.setLayoutData((Object)gridData);
        this.groupCal.setText(Messages.getString((String)"calendar.create"));
        Label lblCalID = new Label((Composite)this.groupCal, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblCalID.setLayoutData((Object)gridData);
        lblCalID.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        this.txtCalID = new Text((Composite)this.groupCal, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtCalID.setLayoutData((Object)gridData);
        this.txtCalID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDialog.this.update();
            }
        });
        Label lblCalName = new Label((Composite)this.groupCal, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblCalName.setLayoutData((Object)gridData);
        lblCalName.setText(String.valueOf(Messages.getString((String)"calendar.name")) + " : ");
        this.txtCalName = new Text((Composite)this.groupCal, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtCalName.setLayoutData((Object)gridData);
        this.txtCalName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDialog.this.update();
            }
        });
        Label lblCalDescription = new Label((Composite)this.groupCal, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblCalDescription.setLayoutData((Object)gridData);
        lblCalDescription.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.txtCalDescription = new Text((Composite)this.groupCal, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtCalDescription.setLayoutData((Object)gridData);
        this.txtCalDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDialog.this.update();
            }
        });
        Label labelRoleId = new Label((Composite)this.groupCal, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        if (this.mode == 0 || this.mode == 3) {
            this.m_ownerRoleId = new RoleIdListComposite((Composite)this.groupCal, 0, true, RoleIdListComposite.Mode.OWNER_ROLE);
            this.m_ownerRoleId.getComboRoleId().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CalendarDialog.this.m_calendarDetailComposite.getDetailList() != null && CalendarDialog.this.m_calendarDetailComposite.getDetailList().size() > 0 && !MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.calendar.50"))) {
                        CalendarDialog.this.m_ownerRoleId.setText(CalendarDialog.this.ownerRoleId);
                        return;
                    }
                    CalendarDialog.this.m_calendarDetailComposite.changeOwnerRoleId(CalendarDialog.this.m_ownerRoleId.getText());
                    CalendarDialog.this.ownerRoleId = CalendarDialog.this.m_ownerRoleId.getText();
                }
            });
        } else {
            this.m_ownerRoleId = new RoleIdListComposite((Composite)this.groupCal, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_ownerRoleId.setLayoutData(gridData);
        Label lblCalTimeFrom = new Label((Composite)this.groupCal, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblCalTimeFrom.setLayoutData((Object)gridData);
        lblCalTimeFrom.setText(String.valueOf(Messages.getString((String)"valid.time")) + "(" + Messages.getString((String)"start") + ")" + " : ");
        this.txtCalTimeFrom = new Text((Composite)this.groupCal, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtCalTimeFrom.setLayoutData((Object)gridData);
        this.txtCalTimeFrom.setEnabled(false);
        this.txtCalTimeFrom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDialog.this.update();
            }
        });
        this.btnTimeFrom = new Button((Composite)this.groupCal, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnTimeFrom.setLayoutData((Object)gridData);
        this.btnTimeFrom.setText(Messages.getString((String)"calendar.button"));
        this.btnTimeFrom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeDialog dialog = new DateTimeDialog(CalendarDialog.this.shell);
                if (CalendarDialog.this.txtCalTimeFrom.getText().length() > 0) {
                    Date date = new Date(CalendarDialog.this.calTimeFrom);
                    dialog.setDate(date);
                }
                if (dialog.open() == 0) {
                    CalendarDialog.this.calTimeFrom = dialog.getDate().getTime();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    String tmp = sdf.format(dialog.getDate());
                    CalendarDialog.this.txtCalTimeFrom.setText(tmp);
                    CalendarDialog.this.update();
                }
            }
        });
        Label lblCalTimeTo = new Label((Composite)this.groupCal, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblCalTimeTo.setLayoutData((Object)gridData);
        lblCalTimeTo.setText(String.valueOf(Messages.getString((String)"valid.time")) + "(" + Messages.getString((String)"end") + ")" + " : ");
        this.txtCalTimeTo = new Text((Composite)this.groupCal, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtCalTimeTo.setLayoutData((Object)gridData);
        this.txtCalTimeTo.setEnabled(false);
        this.txtCalTimeTo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDialog.this.update();
            }
        });
        this.btnTimeTo = new Button((Composite)this.groupCal, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnTimeTo.setLayoutData((Object)gridData);
        this.btnTimeTo.setText(Messages.getString((String)"calendar.button"));
        this.btnTimeTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeDialog dialog = new DateTimeDialog(CalendarDialog.this.shell);
                if (CalendarDialog.this.txtCalTimeTo.getText().length() > 0) {
                    Date date = new Date(CalendarDialog.this.calTimeTo);
                    dialog.setDate(date);
                }
                if (dialog.open() == 0) {
                    CalendarDialog.this.calTimeTo = dialog.getDate().getTime();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    m_log.trace((Object)("CalendarDialog getTime\uff1a" + dialog.getDate()));
                    String tmp = sdf.format(dialog.getDate());
                    CalendarDialog.this.txtCalTimeTo.setText(tmp);
                }
            }
        });
        this.groupCalDetail = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        this.groupCalDetail.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupCalDetail.setLayoutData((Object)gridData);
        this.groupCalDetail.setText(Messages.getString((String)"calendar.detail"));
        GetCalendarDetailTableDefine.get();
        this.m_calendarDetailComposite = new CalendarDetailInfoComposite((Composite)this.groupCalDetail, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 220;
        this.m_calendarDetailComposite.setLayoutData(gridData);
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
        this.adjustDialog();
        this.reflectCalendar();
        this.update();
    }

    private void adjustDialog() {
        this.shell.pack();
        this.shell.setSize(new Point(600, this.shell.getSize().y));
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
    }

    public void update() {
        if ("".equals(this.txtCalID.getText())) {
            this.txtCalID.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtCalID.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtCalName.getText())) {
            this.txtCalName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtCalName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtCalTimeFrom.getText())) {
            this.txtCalTimeFrom.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtCalTimeFrom.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtCalTimeTo.getText())) {
            this.txtCalTimeTo.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtCalTimeTo.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    private ValidateResult createCalendarInfo() {
        ValidateResult result = null;
        this.inputData = new CalendarInfo();
        if (this.txtCalID.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"calendar.id"));
            return result;
        }
        this.inputData.setId(this.txtCalID.getText());
        m_log.trace((Object)("createCalendarInfo cal name = " + this.txtCalName.getText()));
        if (this.txtCalName.getText().length() <= 0 || this.txtCalName.equals("")) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"calendar.name"));
            return result;
        }
        m_log.trace((Object)("createCalendarInfo22 cal name = " + this.txtCalName.getText()));
        this.inputData.setName(this.txtCalName.getText());
        m_log.trace((Object)("input cal name = " + this.inputData.getName()));
        if (this.txtCalDescription.getText().length() > 0) {
            this.inputData.setDescription(this.txtCalDescription.getText());
        } else {
            this.inputData.setDescription("");
        }
        if (this.txtCalTimeFrom.getText().length() > 0) {
            try {
                Date dateTimeFrom = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(this.txtCalTimeFrom.getText());
                this.calTimeFrom = dateTimeFrom.getTime();
                this.inputData.setValidTimeFrom(this.calTimeFrom);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(String.valueOf(Messages.getString((String)"valid.time")) + "(" + Messages.getString((String)"start") + ")" + " : ");
            return result;
        }
        if (this.txtCalTimeTo.getText().length() > 0) {
            try {
                Date dateTimeTo = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(this.txtCalTimeTo.getText());
                this.calTimeTo = dateTimeTo.getTime();
                this.inputData.setValidTimeTo(this.calTimeTo);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(String.valueOf(Messages.getString((String)"valid.time")) + "(" + Messages.getString((String)"end") + ")" + " : ");
            return result;
        }
        if (this.m_calendarDetailComposite.getDetailList() != null) {
            m_log.debug((Object)("Add CalendarDetailInfo : " + this.m_calendarDetailComposite.getDetailList().size()));
            for (CalendarDetailInfo detailInfo : this.m_calendarDetailComposite.getDetailList()) {
                this.inputData.getCalendarDetailList().add(detailInfo);
            }
        }
        if (this.m_ownerRoleId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"owner.role.id"));
            return result;
        }
        this.inputData.setOwnerRoleId(this.m_ownerRoleId.getText());
        return result;
    }

    private void reflectCalendar() {
        CalendarInfo calInfo = null;
        calInfo = this.mode == 1 || this.mode == 3 ? new GetCalendar().getCalendar(this.calendarId) : new CalendarInfo();
        this.inputData = calInfo;
        if (calInfo != null) {
            String tmp;
            SimpleDateFormat sdf;
            if (calInfo.getId() != null) {
                this.calendarId = calInfo.getId();
                this.txtCalID.setText(calInfo.getId());
                if (this.mode == 1) {
                    this.txtCalID.setEnabled(false);
                }
            }
            if (calInfo.getName() != null) {
                this.txtCalName.setText(calInfo.getName());
            }
            if (calInfo.getDescription() != null) {
                this.txtCalDescription.setText(calInfo.getDescription());
            }
            if (calInfo.getValidTimeFrom() != null) {
                sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                tmp = sdf.format(calInfo.getValidTimeFrom());
                this.txtCalTimeFrom.setText(tmp);
                this.calTimeFrom = calInfo.getValidTimeFrom();
            }
            if (calInfo.getValidTimeTo() != null) {
                sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                tmp = sdf.format(calInfo.getValidTimeTo());
                this.txtCalTimeTo.setText(tmp);
                this.calTimeTo = calInfo.getValidTimeTo();
            }
        }
        this.m_calendarDetailComposite.setDetailList((ArrayList)calInfo.getCalendarDetailList());
        if (calInfo.getOwnerRoleId() != null) {
            this.m_ownerRoleId.setText(calInfo.getOwnerRoleId());
        }
        this.ownerRoleId = this.m_ownerRoleId.getText();
        this.m_calendarDetailComposite.setOwnerRoleId(this.m_ownerRoleId.getText());
        this.update();
    }

    @Override
    protected boolean action() {
        boolean result = false;
        this.createCalendarInfo();
        CalendarInfo info = this.inputData;
        if (info != null) {
            if (this.mode == 0) {
                result = new AddCalendar().add(info);
            } else if (this.mode == 1) {
                info.setId(this.txtCalID.getText());
                result = new ModifyCalendar().modify(info);
            } else if (this.mode == 3) {
                info.setId(this.txtCalID.getText());
                result = new AddCalendar().add(info);
            }
        } else {
            m_log.error((Object)"action() Calendarinfo is null");
        }
        return result;
    }
}

