/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.calendar.composite.ScheduleBar;
import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarDetailInfo;
import com.clustercontrol.ws.calendar.CalendarNotFound_Exception;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CalendarWeekComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(CalendarWeekComposite.class);
    private static final int MAX_BAR_LENGTH = 720;
    private static final int BAR_HEIGHT = 15;
    private static final int LEFT_MARGIN = 200;
    private static final int BAR_SPAN = 40;
    private static final long TIMEZONE = TimeZone.getDefault().getRawOffset();
    private static final long DAY24 = 86400000L;
    private FigureCanvas m_canvas;
    private Panel m_panel;
    private Label m_labelId = null;
    private Label[] m_labelMatrix;
    ScheduleBar[] scheduleBars = null;

    public CalendarWeekComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        this.setLayout((Layout)new FillLayout());
        this.m_canvas = new FigureCanvas((Composite)this, 0);
        this.m_canvas.setBackground(ColorConstants.white);
        this.m_panel = new Panel();
        this.m_canvas.setContents((IFigure)this.m_panel);
        this.m_panel.setLayoutManager((LayoutManager)new XYLayout());
    }

    public void update(String calendarId, int year, int month, int day) {
        this.m_panel.removeAll();
        this.m_labelId = new Label(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        this.m_labelId.setVisible(true);
        this.m_panel.add((IFigure)this.m_labelId);
        Dimension dimension = new Dimension(-1, -1);
        Point point = new Point(0, 0);
        Rectangle zeroRectangle = new Rectangle(point, dimension);
        this.m_panel.setConstraint((IFigure)this.m_labelId, (Object)zeroRectangle);
        int i = 0;
        while (i < 25) {
            Label label = new Label(String.format("%02d:00", i));
            label.setVisible(true);
            this.m_panel.add((IFigure)label);
            dimension = new Dimension(-1, -1);
            point = new Point(30 * i + 183, 20);
            zeroRectangle = new Rectangle(point, dimension);
            this.m_panel.setConstraint((IFigure)label, (Object)zeroRectangle);
            i += 3;
        }
        this.m_labelMatrix = new Label[7];
        i = 0;
        while (i < this.m_labelMatrix.length) {
            this.m_labelMatrix[i] = new Label("----/--/--");
            this.m_labelMatrix[i].setVisible(true);
            this.m_panel.add((IFigure)this.m_labelMatrix[i]);
            dimension = new Dimension(-1, -1);
            point = new Point(30, (i + 1) * 40);
            zeroRectangle = new Rectangle(point, dimension);
            this.m_panel.setConstraint((IFigure)this.m_labelMatrix[i], (Object)zeroRectangle);
            ++i;
        }
        if (calendarId == null) {
            return;
        }
        int period = 7;
        Calendar now = Calendar.getInstance();
        now.set(year, month - 1, day);
        int dayOfWeek = now.get(7);
        ScheduleBar[] scheduleBarArray = this.scheduleBars = this.createScheduleBars(this.m_panel, dayOfWeek);
        int n = this.scheduleBars.length;
        int n2 = 0;
        while (n2 < n) {
            ScheduleBar bar = scheduleBarArray[n2];
            bar.getInitBar().setBackgroundColor(ColorConstants.red);
            ++n2;
        }
        try {
            int i2 = 0;
            while (i2 < period) {
                List<CalendarDetailInfo> detailList = CalendarEndpointWrapper.getCalendarWeek(calendarId, year, month, day);
                m_log.trace((Object)("detailList.size=" + detailList.size() + ", " + year + "/" + month + "/" + day));
                ArrayList<CalendarDetailInfo> detailListOrder = new ArrayList<CalendarDetailInfo>();
                while (detailList.size() > 0) {
                    int size = detailList.size();
                    detailListOrder.add(detailList.get(size - 1));
                    detailList.remove(size - 1);
                }
                for (CalendarDetailInfo detail : detailListOrder) {
                    this.addScheduleBar(this.m_panel, dayOfWeek, detail.getTimeFrom(), detail.getTimeTo(), detail.isOperateFlg());
                }
                this.m_labelMatrix[i2].setText(String.valueOf(String.format("%02d/%02d/%02d", year, month, day)) + " ( " + DayOfWeekConstant.typeToString(dayOfWeek) + " )");
                if (day + 1 > now.getActualMaximum(5)) {
                    if (month == 12) {
                        ++year;
                        month = 1;
                    } else {
                        ++month;
                    }
                    day = 1;
                } else {
                    ++day;
                }
                now.set(year, month - 1, day);
                dayOfWeek = now.get(7);
                ++i2;
            }
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (CalendarNotFound_Exception e) {
            m_log.info((Object)("update(), " + e.getMessage()));
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (calendarId != null && calendarId.length() > 0) {
            this.m_labelId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : " + calendarId);
        } else {
            this.m_labelId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        }
    }

    private void addScheduleBar(Panel panel, int dayOfWeek, long from, long to, boolean operationFlg) {
        int fromBar = (int)(720.0f * ((float)(from + TIMEZONE) / 8.64E7f));
        int toBar = (int)(720.0f * ((float)(to + TIMEZONE) / 8.64E7f));
        ScheduleBar scheduleBar = null;
        ScheduleBar[] scheduleBarArray = this.scheduleBars;
        int n = this.scheduleBars.length;
        int n2 = 0;
        while (n2 < n) {
            ScheduleBar bar = scheduleBarArray[n2];
            if (bar.getDayOfWeek() == dayOfWeek) {
                scheduleBar = bar;
            }
            ++n2;
        }
        RectangleFigure barToday = new RectangleFigure();
        barToday.setOutline(false);
        if (operationFlg) {
            barToday.setBackgroundColor(ColorConstants.green);
        } else {
            barToday.setBackgroundColor(ColorConstants.red);
        }
        panel.add((IFigure)barToday, (Object)new Rectangle(200 + fromBar, scheduleBar.getY(), toBar - fromBar, 15));
        this.addCheckPoint(from, scheduleBar.getY(), false);
        this.addCheckPoint(to, scheduleBar.getY(), true);
    }

    private void addCheckPoint(long key, int y, boolean endFlag) {
        long time = key + TIMEZONE;
        m_log.debug((Object)("time = " + time));
        if (time == 0L || time == 86400000L) {
            return;
        }
        Dimension dimension = new Dimension(-1, -1);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        Label label = new Label(format.format(new Date(key)));
        label.setVisible(true);
        this.m_panel.add((IFigure)label);
        dimension = new Dimension(-1, -1);
        int x = (int)(200L + time * 720L / 86400000L);
        if (endFlag) {
            x -= 35;
        }
        Point point = new Point(x, y);
        Rectangle rectangle = new Rectangle(point, dimension);
        this.m_panel.setConstraint((IFigure)label, (Object)rectangle);
    }

    private ScheduleBar[] createScheduleBars(Panel panel, int dayOfWeek) {
        ScheduleBar[] bars = new ScheduleBar[7];
        int i = 0;
        while (i < bars.length) {
            bars[i] = new ScheduleBar(dayOfWeek, 200, 40 * (i + 1));
            dayOfWeek = dayOfWeek == 7 ? 1 : ++dayOfWeek;
            bars[i].getInitBar().setBackgroundColor(ColorConstants.white);
            panel.add((IFigure)bars[i].getInitBar(), (Object)new Rectangle(bars[i].getX(), bars[i].getY(), 720, 15));
            ++i;
        }
        return bars;
    }
}

