/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.calendar.action.GetCalendarPatternTableDefine;
import com.clustercontrol.calendar.composite.action.CalendarPatternDoubleClickListener;
import com.clustercontrol.calendar.composite.action.CalendarPatternSelectionChangedListener;
import com.clustercontrol.calendar.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.calendar.CalendarPatternInfo;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import com.clustercontrol.ws.calendar.Ymd;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CalendarPatternComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(CalendarPatternComposite.class);
    private CommonTableViewer m_viewer = null;
    private Table m_table = null;
    private Label m_labelCount = null;
    private String m_calendarPatternId = null;

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getCalendarPatternId() {
        return this.m_calendarPatternId;
    }

    public void setCalendarPatternId(String id) {
        this.m_calendarPatternId = id;
    }

    public CalendarPatternComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_table = new Table((Composite)this, 68356);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.m_table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(this.m_table);
        this.m_viewer.createTableColumn(GetCalendarPatternTableDefine.get(), 0, 1);
        this.m_viewer.addSelectionChangedListener(new CalendarPatternSelectionChangedListener(this));
        this.m_viewer.addDoubleClickListener(new CalendarPatternDoubleClickListener(this));
        this.m_viewer.getTable().getVerticalBar().addSelectionListener((SelectionListener)new VerticalBarSelectionListener(this));
    }

    public void update() {
        List<CalendarPatternInfo> list = null;
        try {
            list = CalendarEndpointWrapper.getCalendarPatternList(null);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (list == null) {
            list = new ArrayList<CalendarPatternInfo>();
        }
        ArrayList listInput = new ArrayList();
        for (CalendarPatternInfo info : list) {
            ArrayList<Object> obj = new ArrayList<Object>();
            obj.add(info.getId());
            obj.add(info.getName());
            obj.add(info.getYmd().size());
            if (info.getYmd() != null) {
                String set = "";
                int i = 0;
                while (i < info.getYmd().size()) {
                    if (i >= 5) {
                        set = String.valueOf(set) + "...";
                        break;
                    }
                    Ymd ymd = (Ymd)info.getYmd().get(i);
                    set = String.valueOf(set) + ymd.getYear() + "/" + ymd.getMonth() + "/" + ymd.getDay() + " , ";
                    ++i;
                }
                obj.add(set);
            } else {
                obj.add("");
            }
            obj.add(info.getOwnerRoleId());
            obj.add(info.getRegUser());
            obj.add(new Date(info.getRegDate()));
            obj.add(info.getUpdateUser());
            obj.add(new Date(info.getUpdateDate()));
            listInput.add(obj);
        }
        this.m_viewer.setInput(listInput);
        Object[] args = new Object[]{new Integer(list.size())};
        this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
    }
}

