/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.action;

import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.FacilityTreeItemUtil;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public class FacilityTree {
    private static Log m_log = LogFactory.getLog(FacilityTree.class);
    private static FacilityTreeItem m_facilityTreeCache = null;
    private static final Set<Composite> m_DisplayViewSet = new HashSet<Composite>();

    public FacilityTreeItem getTreeItem() {
        FacilityTreeItem item = null;
        if (m_facilityTreeCache == null) {
            FacilityTree.refreshCache();
        }
        item = FacilityTreeItemUtil.deepCopy(m_facilityTreeCache, null);
        return item;
    }

    public String getSeparator() {
        String separator = ">";
        return separator;
    }

    public static void clearCache() {
        m_facilityTreeCache = null;
    }

    public static void refresh() {
        m_log.trace((Object)"FacilityTree.refresh() start");
        FacilityTree.refreshCache();
        FacilityTree.refreshComposite();
        m_log.trace((Object)"FacilityTree.refresh() stop");
    }

    private static void refreshCache() {
        FacilityTreeItem item = null;
        try {
            item = RepositoryEndpointWrapper.getFacilityTree(null);
            if (item != null) {
                m_facilityTreeCache = item;
            }
        }
        catch (Exception e) {
            m_log.warn((Object)("getFacilityTree(), " + e.getMessage()), (Throwable)e);
            return;
        }
        m_log.trace((Object)"FacilityTree.refreshCache() : stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshComposite() {
        m_log.trace((Object)"FacilityTree.refreshComposite() : start");
        Set<Composite> set = m_DisplayViewSet;
        synchronized (set) {
            for (FacilityTreeComposite facilityTreeComposite : m_DisplayViewSet) {
                if (facilityTreeComposite.isDisposed()) continue;
                m_log.trace((Object)("FacilityTree.refreshComposite() : target is " + ((Object)((Object)facilityTreeComposite)).getClass().getCanonicalName()));
                facilityTreeComposite.update();
            }
        }
        m_log.trace((Object)"refreshComposite() : stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComposite(FacilityTreeComposite composite) {
        Set<Composite> set = m_DisplayViewSet;
        synchronized (set) {
            m_DisplayViewSet.add(composite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delComposite(FacilityTreeComposite composite) {
        Set<Composite> set = m_DisplayViewSet;
        synchronized (set) {
            m_DisplayViewSet.remove((Object)composite);
        }
    }
}

