/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.view;

import com.clustercontrol.accesscontrol.composite.RoleListComposite;
import com.clustercontrol.accesscontrol.composite.action.RoleListSelectionChangedListener;
import com.clustercontrol.view.CommonViewPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RoleListView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.accesscontrol.view.RoleListView";
    private RoleListComposite m_roleList = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_roleList = new RoleListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_roleList.setLayoutData(gridData);
        this.createContextMenu();
        this.m_roleList.getTableViewer().addSelectionChangedListener(new RoleListSelectionChangedListener());
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RoleListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_roleList.getTable());
        this.m_roleList.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem roleAdd = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.RoleAddAction");
        ActionContributionItem roleModify = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.RoleModifyAction");
        ActionContributionItem roleDelete = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.RoleDeleteAction");
        manager.add(roleAdd.getAction());
        manager.add(roleModify.getAction());
        manager.add(roleDelete.getAction());
    }

    public void update() {
        this.m_roleList.update();
    }

    public RoleListComposite getComposite() {
        return this.m_roleList;
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleModifyAction", selection);
        super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleDeleteAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleModifyAction", true);
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleDeleteAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleModifyAction", false);
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.RoleDeleteAction", false);
        }
    }
}

