/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.composite;

import com.clustercontrol.accesscontrol.dialog.RoleSettingDialog;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.view.RoleSettingTreeView;
import com.clustercontrol.accesscontrol.viewer.RoleSettingTreeContentProvider;
import com.clustercontrol.accesscontrol.viewer.RoleSettingTreeLabelProvider;
import com.clustercontrol.accesscontrol.viewer.RoleSettingTreeViewer;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.accesscontrol.RoleTreeItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class RoleSettingTreeComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(RoleSettingTreeComposite.class);
    private RoleSettingTreeViewer m_viewer = null;
    private RoleSettingTreeView m_view = null;
    private RoleTreeItem m_selectItem = null;

    public RoleSettingTreeComposite(RoleSettingTreeView view, Composite parent, int style) {
        super(parent, style);
        this.m_view = view;
        this.initialize();
    }

    public RoleSettingTreeComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public RoleSettingTreeComposite(Composite parent, int style, RoleTreeItem selectItem) {
        super(parent, style);
        this.m_selectItem = selectItem;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Tree tree = new Tree((Composite)this, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        this.m_viewer = new RoleSettingTreeViewer(tree);
        this.m_viewer.setContentProvider((IContentProvider)new RoleSettingTreeContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new RoleSettingTreeLabelProvider());
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                RoleSettingTreeComposite.this.m_selectItem = (RoleTreeItem)selection.getFirstElement();
            }
        });
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                RoleTreeItem item = (RoleTreeItem)selection.getFirstElement();
                Object data = item.getData();
                if (data instanceof RoleInfo && !((RoleInfo)data).getId().equals("root")) {
                    RoleSettingDialog dialog = new RoleSettingDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ((RoleInfo)data).getId());
                    if (dialog.open() == 0) {
                        RoleSettingTreeComposite.this.m_view.update();
                    }
                } else {
                    return;
                }
            }
        });
        this.update();
    }

    public RoleSettingTreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    public Tree getTree() {
        return this.m_viewer.getTree();
    }

    public void update() {
        RoleTreeItem tree = null;
        try {
            tree = AccessEndpointWrapper.getRoleTree();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update() getJobTree, " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        this.m_selectItem = null;
        this.m_viewer.setInput(tree);
    }

    public RoleTreeItem getSelectItem() {
        return this.m_selectItem;
    }

    public void setSelectItem(RoleTreeItem item) {
        this.m_selectItem = item;
    }
}

