/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.RunJobRequest;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.dialogs.StopInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.util.Messages;

public class StopInstanceAction extends MultiSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.StopInstanceAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String strFacilityId = messages.getString("word.facility_id");
	private String strInstanceId = messages.getString("word.instance_id");
	private String msgStopTemplateInstanceConfirm = messages.getString("message.stop_template_instance_confirm");
	private String msgStopInstanceConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.instance", "word.stop"});
	private String msgStopInstanceResult = messages.getString("message.some_command_has_been_accepted", new Object[]{"word.instance", "word.stop"});

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		Iterator<?> iter = selection.iterator();
		while (iter.hasNext()) {
			ICloudInstance instance = (ICloudInstance)iter.next();
			
			if (instance.getState() == null || ICloudInstance.StateType.running != ICloudInstance.StateType.byLabel(instance.getState())) {
				return false;
			}
		}
		
		return true;
	}

	@Override
	protected void invoke(IAction action) {
		IRegion region = ((InstancesView)viewPart).getActiveRegion();
		
		ICloudTemplateManager templateManager = region.getAccountResource().getCloudTemplateManager();
		ICloudInstance tmpInstance = null;
		StringBuffer sb = new StringBuffer();
		String confirmMessage = "";
		StopInstanceDialog.DialogOutput output = null;
		if(((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).size() > 1){
			Iterator<?> iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
			int i = 0;
			while (iter.hasNext()) {
				ICloudInstance instance = (ICloudInstance)iter.next();
				sb.append(strFacilityId + " = " + instance.getFacilityId() + ", "  + strInstanceId + " = " + instance.getInstanceId()); 
				if(iter.hasNext()) sb.append(", ");
				i++;
				if(i > 10){
					sb.append("\n");
					i = 0;
				}
			}
			confirmMessage = msgStopTemplateInstanceConfirm+"\n"+sb;
		} else {
			tmpInstance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
			sb.append(strFacilityId + " = " + tmpInstance.getFacilityId() + ", " + strInstanceId + " = " + tmpInstance.getInstanceId()); 
			StopInstanceDialog dialog = new StopInstanceDialog(viewPart.getSite().getShell());
			StopInstanceDialog.DialogInput input = new StopInstanceDialog.DialogInput();
			input.setInstanceId(tmpInstance.getInstanceId());
			input.setRegion(tmpInstance.getRegion());
			input.setAccountResourceId(tmpInstance.getCloudInstanceManager().getRegion().getAccountResource().getAccountResourceId());
			if(tmpInstance.getTemplateId() != null && !tmpInstance.getTemplateId().equals("")){
				input.setTemplateId(tmpInstance.getTemplateId());
			}
			dialog.setInput(input);
			if(dialog.open() == Window.OK){
				output = dialog.getOutput();
			} else {
				return;
			}
			confirmMessage = msgStopInstanceConfirm+"\n"+sb;
		}
		
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			confirmMessage)){
	
			if(tmpInstance == null){
				Iterator<?> iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
				while (iter.hasNext()) {
					tmpInstance = (ICloudInstance)iter.next();
					if(tmpInstance.getTemplateId() != null && !tmpInstance.getTemplateId().equals("")){
						ICloudTemplate template = templateManager.getCloudTemplate(tmpInstance.getTemplateId());
						RunJobRequest request = new RunJobRequest();
						request.setJobId(template.getStopJobId());
						request.setRunJobFlg(true);
						tmpInstance.stop(request);
					} else {
						tmpInstance.stop();
					}
				}
			} else {
				RunJobRequest request = new RunJobRequest();
				request.setJobId(output.getJobId());
				request.setRunJobFlg(output.getRunJobFlg());
				request.setArguments(output.getArguments());
				tmpInstance.stop(request);
			}

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgStopInstanceResult);

			final Iterator<?> iter2 = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
			final InstancesView view = (InstancesView)viewPart;
			view.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					while (iter2.hasNext()) {
						InstanceMonitorService.getInstanceMonitorService().startMonitor((ICloudInstance)iter2.next(), ICloudInstance.StateType.stopped);
					}
				}
			});
		}
	}
}