package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.plugin.action.IActionPluginProvider;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.ui.views.IAROrientedView;

public abstract class PluginBaseAction extends AbstractViewAction implements IPropertyListener {
	protected IActionPluginProvider actionPluginProvider;

	@Override
	public void init(IViewPart view) {
		super.init(view);

		assert view instanceof IAROrientedView;
		
		view.addPropertyListener(this);
	}
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		actionPluginProvider.getAction(getPluginId()).run(action);
	}

	protected abstract String getPluginId();

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(actionPluginProvider != null && actionPluginProvider.isSupported(getPluginId())){
			actionPluginProvider.getAction(getPluginId()).selectionChanged(action, selection);
		} else {
			action.setEnabled(false);
		}
	}

	@Override
	public void propertyChanged(Object source, int propId) {
		if (IAROrientedView.Prop_AccountResource != propId) {
			return;
		}

		IAccountResource accountResource = ((IAROrientedView)viewPart).getCurrentAccountResource();
		if (accountResource != null) {
			String cloudTypeId = Activator.getDefault().getCloudResourceManager().getCloudServiceManager()
					.getCloudService(accountResource.getCloudServiceId()).getCloudTypeId();

			if (actionPluginProvider == null || !cloudTypeId.equals(actionPluginProvider.getCloudTypeId())) {
				if (Activator.getDefault().getActionPluginManager().isPlugined(cloudTypeId)) {
					actionPluginProvider = Activator.getDefault().getActionPluginManager().getActionPluginProvider(cloudTypeId);
					if(actionPluginProvider.isSupported(getPluginId())){
						actionPluginProvider.getAction(getPluginId()).init(viewPart);
					}
				}
			}
		}
		else {
			actionPluginProvider = null;
		}

		viewPart.getSite().getSelectionProvider().setSelection(viewPart.getSite().getSelectionProvider().getSelection());
	}
}