package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.AccountControlUtil.NotFoundAccountResourceException;
import com.clustercontrol.cloud.presenter.IFacility;

public class ChangeActiveCloudUserAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.ChangeActiveCloudUserAction";

	@Override
	protected void invoke(IAction action) throws InvocationException {
		try {
			AccountControlUtil.selectActiveUser(viewPart);
		}
		catch (NotFoundAccountResourceException e) {
			throw new InvocationException(e);
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		if(action.isEnabled()){
			IFacility facility = (IFacility)((IStructuredSelection)selection).getFirstElement();
			if(
				facility != null &&
				facility.getAccountResourceId() != null &&
				!facility.getAccountResourceId().isEmpty()
			){
				try {
					if(!AccountControlUtil.isInitializedActiveUser(facility.getAccountResourceId())){
						AccountControlUtil.selectActiveUser(viewPart);
					}
					if(AccountControlUtil.getAvailableCloudUsers(facility.getAccountResourceId()).size() > 1){
						action.setEnabled(true);
					} else {
						action.setEnabled(false);
					}
				} catch (NotFoundAccountResourceException e) {
					action.setEnabled(false);
				}
			} else {
				action.setEnabled(false);
			}
		}
	}
}
