/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CreateStorageBackupRequest;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageBackupDialog;
import com.clustercontrol.util.Messages;

public class BackupStorageAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.BackupStorage";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgBackupStorageConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage_backup", "word.create"});
	private String msgBackupStorageResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.storage_backup", "word.create"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudStorage storage = (ICloudStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();

		CreateStorageBackupDialog dialog = new CreateStorageBackupDialog(this.viewPart.getSite().getShell(), storage);
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgBackupStorageConfirm)){
				
				CreateStorageBackupRequest request = new CreateStorageBackupRequest();
				request.setSnapshotName(dialog.getName());
				request.setDescription(dialog.getDescription());
				request.setStorageId(storage.getStorageId());
				storage.getCloudStorageManager().getCloudComputeService().getStorageBackupManager().backupCloudStorage(request);

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgBackupStorageResult);
	
			} else {
				return;
			}
		}
	}
}