/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.ICloudService;
import com.clustercontrol.cloud.presenter.ICloudServiceManager;
import com.clustercontrol.cloud.presenter.IElement;

/**
 */
public class CloudServicesView extends AbstractCloudViewPart {
	@Override
	public void dispose() {
		super.dispose();
	}

	public static final String Id = "com.clustercontrol.cloud.ui.views.CloudServicesView";

	private static MessageManager bundle_messages = MessageManager.getInstance("messages");
	
	private Table table;
	private TableViewer tableViewer;
//	private Label lblHeader;
	private Label lblFooter;
	private List<ICloudService> cloudServices = new ArrayList<ICloudService>();
	private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");
	private ICloudServiceManager manager = Activator.getDefault().getCloudResourceManager().getCloudServiceManager();

	private CollectionObserver2<ICloudService> elementObserver = new CollectionObserver2<ICloudService>() {
		@Override
		public void elementAdded(ElementAddedEvent<ICloudService> event) {
			event.getAddedElement().addPropertyObserver2(IElement.allProperty, propertyObserver);

			cloudServices.add(event.getAddedElement());
			tableViewer.setInput(cloudServices);

			lblFooter.setText(footerTitle + cloudServices.size());

			CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudServicesView.this.tableViewer.getSelection();
					CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<ICloudService> event) {
			event.getRemovedElement().removePropertyObserver2(IElement.allProperty, propertyObserver);

			cloudServices.remove(event.getRemovedElement());
			tableViewer.setInput(cloudServices);
			
			lblFooter.setText(footerTitle + cloudServices.size());

			CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudServicesView.this.tableViewer.getSelection();
					CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	private AllPropertyObserver propertyObserver = new AllPropertyObserver() {
		@Override
		public void propertyChanged(ValueChangedEvent event) {
			CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudServicesView.this.tableViewer.getSelection();
					CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementRemoved(ElementRemovedEvent event) {
			CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudServicesView.this.tableViewer.getSelection();
					CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementAdded(ElementAddedEvent event) {
			CloudServicesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = CloudServicesView.this.tableViewer.getSelection();
					CloudServicesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};
	
 	public CloudServicesView() {
	}

 	@Override
	protected void internalCreatePartControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

//		lblHeader = new Label(composite, SWT.NONE);
//		lblHeader.setSize(lblHeader.getSize().x, 80);
//		GridData gridData = new GridData();
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.verticalAlignment = GridData.FILL;
//		lblHeader.setLayoutData(gridData);
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		for(final ViewColumn column: ViewColumn.values()){
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tcl_composite_1.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}

		this.getSite().setSelectionProvider(tableViewer);
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		lblFooter = new Label(composite, SWT.NONE);
		lblFooter.setAlignment(SWT.RIGHT);
		lblFooter.setSize(lblFooter.getSize().x, 80);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblFooter.setLayoutData(gridData);
		
		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});
		
		

		try {
			update();
		}
		catch (Throwable e) {
			lblFooter.setText(footerTitle + 0);
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
		}
	}

	
	private List<ICloudService> getCloudServices() {
		if (cloudServices == null) {
			try {
				for (ICloudService cl: manager.getCloudServices()) {
					cl.addPropertyObserver2(IElement.allProperty, propertyObserver);
				}
				
				cloudServices = new ArrayList<ICloudService>();
				cloudServices.addAll(Arrays.asList(manager.getCloudServices()));
				manager.addPropertyObserver2(ICloudServiceManager.p2.cloudServices, elementObserver);
				
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				cloudServices = new ArrayList<ICloudService>();
			}
		}
		
		return cloudServices;
	}
	

	public void update() {
		if (cloudServices != null) {
			for (ICloudService cloud: cloudServices) {
				cloud.removePropertyObserver2(IElement.allProperty, propertyObserver);
			}
			cloudServices = null;
		}

		if (manager != null) {
			manager.removePropertyObserver2(ICloudServiceManager.p2.cloudServices, elementObserver);
			manager.update();
		}
		
		List<ICloudService> cloudServices = getCloudServices();
		
		
		tableViewer.setInput(cloudServices);
		lblFooter.setText(footerTitle + cloudServices.size());
	}
	
	private enum ViewColumn{
		cloud_service_id(
			bundle_messages.getString("word.cloud_service_id"),
			new ColumnPixelData(180, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudService)element).getCloudServiceId();
				}
			}
		),
		cloud_service_name(
			bundle_messages.getString("word.cloud_service_name"),
			new ColumnPixelData(180, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudService)element).getCloudServiceName();
				}
			}
		),
		cloud_type_id(
			bundle_messages.getString("word.cloud_type_id"),
			new ColumnPixelData(180, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudService)element).getCloudTypeId();
				}
			}
		),
		description(
			bundle_messages.getString("word.description"),
			new ColumnPixelData(180, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudService)element).getDescription();
				}
			}
		);
//		reg_date(
//			bundle_view_label.getString("view.cloud_service.column.reg_date"),
//			new ColumnPixelData(100, true, true),
//			new ColumnLabelProvider(){
//				@Override
//				public String getText(Object element) {
//					if(((ICloudService)element).getRegDate() != null){
//						return format.format(((ICloudService)element).getRegDate());
//					}
//					return "";
//				}
//			}
//		),
//		reg_user(
//			bundle_view_label.getString("view.cloud_service.column.reg_user"),
//			new ColumnPixelData(100, true, true),
//			new ColumnLabelProvider(){
//				@Override
//				public String getText(Object element) {
//					return ((ICloudService)element).getRegUser();
//				}
//			}
//		),
//		update_date(
//			bundle_view_label.getString("view.cloud_service.column.update_date"),
//			new ColumnPixelData(100, true, true),
//			new ColumnLabelProvider(){
//				@Override
//				public String getText(Object element) {
//					if(((ICloudService)element).getUpdateDate() != null){
//						return format.format(((ICloudService)element).getUpdateDate());
//					}
//					return "";
//				}
//			}
//		),
//		update_user(
//			bundle_view_label.getString("view.cloud_service.column.update_user"),
//			new ColumnPixelData(100, true, true),
//			new ColumnLabelProvider(){
//				@Override
//				public String getText(Object element) {
//					return ((ICloudService)element).getUpdateUser();
//				}
//			}
//		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
//		private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}

	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
}