package com.clustercontrol.cloud.presenter;


public abstract class InternalComponent<C extends IInternalContainer<?, S>, S> extends Element implements IInternalComponent<C, S> {
	private C container;
	
	public InternalComponent(C container) {
		this.container = container;
	}
	
	public C getContainer() {
		return container;
	}
	
	@Override
	public void update() throws CloudModelException {
		S source = getSource();

		if (source != null) {
			internalUpdate(source);
		}
		
		super.update();
	}

	public abstract S getSource() throws CloudModelException;
	
	@Override
	public void internalUpdate(S source) {
		overwrite(source);
	}

	protected abstract void overwrite(S source);
}