/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.presenter.INode.NodeType;
import com.clustercontrol.repository.bean.FacilityConstant;
import com.clustercontrol.repository.bean.FacilityTreeAttributeConstant;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;

public class FacilityRoot extends Element implements IFacilityRoot {
//	private MessageManager bundle_messages = MessageManager.getInstance("messages");
	
	private HinemosService hinemosService;
	private RootScope rootScope;

	public FacilityRoot(HinemosService hinemosService) {
		this.hinemosService = hinemosService;

		try {
			FacilityTreeItem fti = new FacilityTree().getTreeItem();
			
			List<FacilityTreeItem> roots = collectTopScope(fti);
			for (FacilityTreeItem root: roots) {
				if ("Cloud".equals(root.getData().getFacilityId())) {
					rootScope = new RootScope(this);
					
					rootScope.setName(root.getData().getFacilityName());
					rootScope.setFacilityId(root.getData().getFacilityId());
					rootScope.setScopeType(IScope.ScopeType.root);
					
					convertChildren(rootScope, root);
					break;
				}
			}
			
//			if (rootScope == null) {
//				throw new CloudModelException(bundle_messages.getString("message.not_found_root_scope"), ErrorCodeConstants.FACILITYROOT_INVALID_ROOT_SCOPE_NOT_FOUND);
//			}
		}
		catch (Exception e) {
			throw new CloudModelException("faild to get repositry tree.", e);
		}
	}

	@Override
	public void update() throws CloudModelException {
//		FacilityTreeItem facilityTreeItem = CacheService.getSingleton().get(this, FacilityTreeItem.class);
//		if (facilityTreeItem == null) {
//			try {
//				facilityTreeItem = new FacilityTree().getTreeItem();
//			}
//			catch (Exception e) {
//				Logger logger = Logger.getLogger(this.getClass());
//				logger.error("faild to get repositry tree.", e);
//			}
//		}
//		else {
//			CacheService.getSingleton().remove(this);
//		}
		
		try {
//			List<FacilityTreeItem> roots = collectTopScope(facilityTreeItem);
			List<FacilityTreeItem> roots = collectTopScope(new FacilityTree().getTreeItem());
			FacilityTreeItem cloudRoot = null;
			for (FacilityTreeItem root: roots) {
				if ("Cloud".equals(root.getData().getFacilityId())) {
					cloudRoot = root;
					break;
				}
			}

//			if (cloudRoot == null) {
//				rootScope = null;
//				fireElementRemoved(p2.scopes, rootScope);
//				throw new CloudModelException(bundle_messages.getString("message.not_found_root_scope"), ErrorCodeConstants.FACILITYROOT_INVALID_ROOT_SCOPE_NOT_FOUND);
//			}

			if (cloudRoot != null) {
				if (rootScope == null) {
					rootScope = new RootScope(this);
					
					rootScope.setName(cloudRoot.getData().getFacilityName());
					rootScope.setFacilityId(cloudRoot.getData().getFacilityId());
					rootScope.setScopeType(IScope.ScopeType.root);
					
					if (cloudRoot != null) {
						convertChildren(rootScope, cloudRoot);
					}
					
					fireElementAdded(p2.scopes, rootScope);
				}
				else {
					recursiveUpdateScope(rootScope, cloudRoot);
				}
			}
			else {
				if (rootScope != null) {
					RootScope oldScope = rootScope;
					fireElementRemoved(p2.scopes, oldScope);
				}
			}
		}
		catch (CloudModelException e) {
			throw e;
		}
		catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error("faild to get repositry tree.", e);
		}
		
		super.update();
	}
	
	private void recursiveUpdateScope(Scope parentScope, FacilityTreeItem facilityTreeItem){
		parentScope.setName(facilityTreeItem.getData().getFacilityName());

		List<FacilityTreeItem> treeItems = new ArrayList<>(facilityTreeItem.getChildren());

		List<Scope> scopes = new ArrayList<>(Arrays.asList(parentScope.getScopes()));
		Iterator<Scope> scopesIter = scopes.iterator();
		while (scopesIter.hasNext()) {
			Scope scope = scopesIter.next();
			
			Iterator<FacilityTreeItem> treeItemIter = treeItems.iterator();
			while (treeItemIter.hasNext()) {
				FacilityTreeItem treeItem = treeItemIter.next();
				FacilityInfo fi = treeItem.getData();
		
				if (fi.getFacilityType() == FacilityConstant.TYPE_SCOPE) {
					if (fi.getFacilityId().equals(scope.getFacilityId())) {
						recursiveUpdateScope(scope, treeItem);

						scopesIter.remove();
						treeItemIter.remove();
					}
				}
			}
		}
		
		for (Scope scope: scopes) {
			parentScope.removeChildScope(scope);
		}
		
		List<Node> nodes = new ArrayList<>(Arrays.asList(parentScope.getNodes()));
		Iterator<Node> nodesIter = nodes.iterator();
		while (nodesIter.hasNext()) {
			Node node = nodesIter.next();
			
			Iterator<FacilityTreeItem> treeItemIter = treeItems.iterator();
			while (treeItemIter.hasNext()) {
				FacilityTreeItem treeItem = treeItemIter.next();
				FacilityInfo fi = treeItem.getData();
		
				if (fi.getFacilityType() == FacilityConstant.TYPE_NODE) {
					if (fi.getFacilityId().equals(node.getFacilityId())) {
						node.setName(fi.getFacilityName());

						nodesIter.remove();
						treeItemIter.remove();
					}
				}
			}
		}
		
		for(Node node: nodes){
			parentScope.removeChildNode(node);
		}

		for (FacilityTreeItem treeItem: treeItems) {
			convertChild(parentScope, treeItem);
		}
	}
	
	@Override
	public Scope[] getScopes() {
		if (rootScope != null) {
			return new Scope[]{rootScope};
		}
		else {
			return new Scope[0];
		}
	}

	public CloudResourceManager getCloudResourceManager() {
		return getHinemosService().getCloudResourceManager();
	}

	@Override
	public HinemosService getHinemosService() {
		return hinemosService;
	}

	/**
	 * FacilityInfo に該当する LNode を新規作成する。
	 * 
	 * @param fi
	 * @return
	 */
	private static Node convertNode(Scope parent, INode.NodeType nodeType, FacilityTreeItem fti) {
		Node node = new Node();
		node.setParent(parent);
		node.setName(fti.getData().getFacilityName());
		node.setFacilityId(fti.getData().getFacilityId());
		node.setNodeType(nodeType);

		return node;
	}

	/**
	 * Hinemos のツリー情報を元に LScope を新規作成する。
	 * 
	 * @param fti
	 * @return
	 */
	private Scope convertScope(Scope parent, IScope.ScopeType type, FacilityTreeItem fti) {
		try {
			FacilityInfo fi = fti.getData();
			assert fi.getFacilityType() == FacilityConstant.TYPE_SCOPE: "unexpected";
			
			Scope scope = new Scope();
			scope.setParent(parent);
			scope.setName(fi.getFacilityName());
			scope.setFacilityId(fti.getData().getFacilityId());
			scope.setScopeType(type);
	
			return scope;
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}
	}

	private void convertChildren(Scope scope, FacilityTreeItem fti) {
		for (FacilityTreeItem child: fti.getChildren()) {
			convertChild(scope, child);
		}
	}
	
	private void convertChild(Scope parent, FacilityTreeItem child) {
		switch(child.getData().getFacilityType()) {
		case FacilityConstant.TYPE_SCOPE:
			IScope.ScopeType nextType = null;
			switch (parent.getScopeType()) {
			case root:
//				if(child.getData().getFacilityId().equals("CloudAccountResourceList")){
//					nextType = IScope.ScopeType.account_resource_list;
//				}
				if(child.getData().getFacilityId().endsWith("_Scope")){
					for (AccountResource ar: hinemosService.getCloudResourceManager().getAccountResourceManager().getAccountResources()) {
						if (child.getData().getFacilityId().equals(ar.getAccountResourceId() + "_Scope")) {
							nextType = IScope.ScopeType.account_resource_scope;
							break;
						}
					}
				}
				break;
//			case account_resource_list:
//				nextType = IScope.ScopeType.account_resource_group;
//				break;
			case account_resource_scope:
				nextType = IScope.ScopeType.region;
				break;
			case region:
				nextType = IScope.ScopeType.zone;
				break;
			default:
				break;
			}

			if (nextType != null) {
				Scope childScope = convertScope(parent, nextType, child);
				parent.addChildScope(childScope);
				convertChildren(childScope, child);
			}
			break;
		case FacilityConstant.TYPE_NODE:
			// アベイラビリティーゾーンのスコープでない場合は、スキップ
			switch (parent.getScopeType()) {
//			case account_resource_group:
//				parent.addChildNode(convertNode(parent, NodeType.account_resource, child));
//				break;
			case zone:
				parent.addChildNode(convertNode(parent, NodeType.node, child));
				break;
			default:
				break;
			}
			break;
		default:
			break;
		}
	}

	/**
	 * 指定した Facility が、Hinemos 内部のスコープか確認。
	 * 
	 * @param facility
	 * @return
	 */
	private static boolean isInternalScope(FacilityInfo facility) {
		if (
			facility.getFacilityType() == FacilityConstant.TYPE_SCOPE &&
			(FacilityTreeAttributeConstant.REGISTEREFD_SCOPE.equals(facility.getFacilityId()) ||
			FacilityTreeAttributeConstant.INTERNAL_SCOPE.equals(facility.getFacilityId()) ||
			FacilityTreeAttributeConstant.UNREGISTEREFD_SCOPE.equals(facility.getFacilityId()))
			) {
			return true;
		}
		return false;
	}
	
	/**
	 * Hinemos のモデルから、Top レベルのスコープ情報を検出する。
	 * 
	 * @param treeItem
	 * @param buf
	 * @return
	 */
	private List<FacilityTreeItem> collectTopScope(FacilityTreeItem treeItem) {
		List<FacilityTreeItem> buf = new ArrayList<FacilityTreeItem>();
		return recursiveCollectTopScope(treeItem, buf);
	}

	private List<FacilityTreeItem> recursiveCollectTopScope(FacilityTreeItem treeItem, List<FacilityTreeItem> buf) {
		if (!isScope(treeItem.getData())) {
			for (FacilityTreeItem fti: treeItem.getChildren()) {
				recursiveCollectTopScope(fti, buf);
			}
		}
		else {
			buf.add(treeItem);
		}
		
		return buf;
	}
	
	/**
	 * 指定した FacilityInfo が、有効なスコープ情報か確認。
	 * 
	 * @param treeItem
	 * @param buf
	 * @return
	 */
	private boolean isScope(FacilityInfo facility) {
		switch(facility.getFacilityType()) {
		case FacilityConstant.TYPE_SCOPE:
			// Hinemos のインターナルのスコープの場合、対象外。
			if (!isInternalScope(facility)) {
				return true;
			}
			break;
		}
		
		return false;
	}
}
