/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.base.resources.Image;
import com.clustercontrol.cloud.aws.base.resources.Subnet;
import com.clustercontrol.cloud.aws.base.ui.dialogs.InstanceDetailDialog;
import com.clustercontrol.cloud.aws.base.ui.dialogs.SelectAMIDialog;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.ui.dialogs.EditTemplateJobArgumentDialog;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateInstanceDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strNodeInfo = this.messages.getString("word.node_info");
    private String strFacilityId = this.messages.getString("word.facility_id");
    private String strNodeReplaceDescription = this.messages.getString("caption.node_replace_description");
    private String strFacilityName = this.messages.getString("word.facility_name");
    private String strDescription = this.messages.getString("word.description");
    private String strNodeName = this.messages.getString("word.node_name");
    private String strInstanceInfo = this.messages.getString("word.instance_info");
    private String strRegion = this.messages.getString("word.region");
    private String strAvailabilityZone = this.messages.getString("word.availability_zone");
    private String strVpcEnable = this.messages.getString("caption.vpc_enable");
    private String strSubnet = this.messages.getString("word.subnet");
    private String strKeyPair = this.messages.getString("word.key_pair");
    private String strAmi = this.messages.getString("word.ami");
    private String strRefer = this.messages.getString("word.refer");
    private String strUseTemplate = this.messages.getString("caption.use_subjects", new Object[]{"word.template"});
    private String strTemplate = this.messages.getString("word.template");
    private String strEditArgument = this.messages.getString("caption.edit_argument");
    private String strDetailSettings = this.messages.getString("word.detail_settings");
    private String strCreateInstanceDialog = this.messages.getString("caption.create_instance_dialog");
    private String msgSubnetDoesNotExists = this.messages.getString("message.subnet_does_not_exists");
    private String msgTemplateDoesNotExists = this.messages.getString("message.template_does_not_exists");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private String msgThatRegionHasNoKeypair = this.messages.getString("message.that_region_has_no_key_pair");
    private Shell shell;
    private Text facilityId;
    private Button btnReplaceNode;
    private Text facilityName;
    private Text description;
    private Text nodeName;
    private Combo cmbRegion;
    private Combo cmbAvailabilityZone;
    private Combo cmbKeyPair;
    private Text txtAMI;
    private Combo cmbTemplate;
    private Button btnUseTemplate;
    private Button btnSelectAMI;
    private Button btnEditArgument;
    private ControlDecoration ctdcKeyPair;
    private CloudResourceProvider provider;
    private Model input;
    private Model output = new Model();
    private IDialogBehavior behavior = new DialogBehavior();
    private ICloudTemplateManager cloudTemplateManager;
    private List<TemplateJobsArgument> arguments;
    private Label lblAvailabilityZone;
    private Label lblAMI;
    private Label lblUseTemplate;
    private Label lblLaunchInVPC;
    private Label lblTemplate;
    private Button btnLaunchInVPC;
    private Combo cmbSubnet;
    private Label lblSubnet;

    public void setCloudTemplateManager(ICloudTemplateManager cloudTemplateManager) {
        this.cloudTemplateManager = cloudTemplateManager;
    }

    public CreateInstanceDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(1, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Group grpNodeInfo = new Group(container, 0);
        grpNodeInfo.setText(this.strNodeInfo + this.strSeparator);
        GridLayout gl_grpNodeInfo = new GridLayout(2, false);
        gl_grpNodeInfo.verticalSpacing = 9;
        gl_grpNodeInfo.horizontalSpacing = 15;
        grpNodeInfo.setLayout((Layout)gl_grpNodeInfo);
        grpNodeInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        Label lblid = new Label((Composite)grpNodeInfo, 131072);
        lblid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblid.setText(this.strFacilityId + this.strSeparator);
        this.facilityId = new Text((Composite)grpNodeInfo, 2048);
        this.facilityId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label((Composite)grpNodeInfo, 0);
        this.btnReplaceNode = new Button((Composite)grpNodeInfo, 32);
        this.btnReplaceNode.setText(this.strNodeReplaceDescription);
        Label lblFacilityName = new Label((Composite)grpNodeInfo, 131072);
        lblFacilityName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFacilityName.setText(this.strFacilityName + this.strSeparator);
        this.facilityName = new Text((Composite)grpNodeInfo, 2048);
        this.facilityName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblDescription = new Label((Composite)grpNodeInfo, 131072);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.strDescription + this.strSeparator);
        this.description = new Text((Composite)grpNodeInfo, 2048);
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblNodeName = new Label((Composite)grpNodeInfo, 131072);
        lblNodeName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNodeName.setText(this.strNodeName + this.strSeparator);
        this.nodeName = new Text((Composite)grpNodeInfo, 2048);
        GridData gd_nodeName = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_nodeName.widthHint = 66;
        this.nodeName.setLayoutData((Object)gd_nodeName);
        Group grpInstacneInfo = new Group(container, 0);
        grpInstacneInfo.setText(this.strInstanceInfo);
        GridLayout gl_grpInstacneInfo = new GridLayout(3, false);
        gl_grpInstacneInfo.verticalSpacing = 9;
        gl_grpInstacneInfo.horizontalSpacing = 15;
        grpInstacneInfo.setLayout((Layout)gl_grpInstacneInfo);
        GridData gd_grpInstacneInfo = new GridData(4, 0x1000000, false, false, 5, 1);
        gd_grpInstacneInfo.heightHint = 350;
        grpInstacneInfo.setLayoutData((Object)gd_grpInstacneInfo);
        Label lblRegion = new Label((Composite)grpInstacneInfo, 131072);
        lblRegion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblRegion.setText(this.strRegion + this.strSeparator);
        this.cmbRegion = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbRegion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cmbRegion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateInstanceDialog.this.cmbKeyPair.removeAll();
                for (String keyName : CreateInstanceDialog.this.provider.getKeyNames((String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()))) {
                    CreateInstanceDialog.this.cmbKeyPair.add(keyName);
                }
                if (CreateInstanceDialog.this.cmbKeyPair.getItemCount() > 0) {
                    CreateInstanceDialog.this.cmbKeyPair.setEnabled(true);
                    CreateInstanceDialog.this.cmbKeyPair.select(0);
                } else {
                    CreateInstanceDialog.this.cmbKeyPair.setEnabled(false);
                }
                CreateInstanceDialog.this.checkKeyPair();
                String regionName = (String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText());
                CreateInstanceDialog.this.cmbAvailabilityZone.removeAll();
                List<AvailabilityZone> azs = CreateInstanceDialog.this.provider.getAvailabilityZones(regionName);
                for (AvailabilityZone az : azs) {
                    CreateInstanceDialog.this.cmbAvailabilityZone.add(az.getZoneName());
                }
                CreateInstanceDialog.this.cmbAvailabilityZone.select(0);
                CreateInstanceDialog.this.cmbSubnet.removeAll();
                CreateInstanceDialog.this.btnLaunchInVPC.setSelection(false);
                CreateInstanceDialog.this.lblAvailabilityZone.setEnabled(true);
                CreateInstanceDialog.this.cmbAvailabilityZone.setEnabled(true);
                CreateInstanceDialog.this.lblSubnet.setEnabled(false);
                CreateInstanceDialog.this.cmbSubnet.setEnabled(false);
                CreateInstanceDialog.this.btnUseTemplate.setSelection(false);
                CreateInstanceDialog.this.cmbTemplate.removeAll();
                CreateInstanceDialog.this.lblTemplate.setEnabled(false);
                CreateInstanceDialog.this.cmbTemplate.setEnabled(false);
                CreateInstanceDialog.this.btnEditArgument.setEnabled(false);
                CreateInstanceDialog.this.lblAMI.setEnabled(true);
                CreateInstanceDialog.this.txtAMI.setEnabled(true);
                CreateInstanceDialog.this.btnSelectAMI.setEnabled(true);
                CreateInstanceDialog.this.txtAMI.setText("");
                CreateInstanceDialog.this.txtAMI.setData(null);
            }
        });
        this.lblAvailabilityZone = new Label((Composite)grpInstacneInfo, 0);
        this.lblAvailabilityZone.setAlignment(131072);
        this.lblAvailabilityZone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblAvailabilityZone.setText(this.strAvailabilityZone + this.strSeparator);
        this.cmbAvailabilityZone = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbAvailabilityZone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblLaunchInVPC = new Label((Composite)grpInstacneInfo, 0);
        this.lblLaunchInVPC.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblLaunchInVPC.setAlignment(131072);
        this.lblLaunchInVPC.setText(this.strVpcEnable + this.strSeparator);
        this.btnLaunchInVPC = new Button((Composite)grpInstacneInfo, 32);
        this.btnLaunchInVPC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInstanceDialog.this.btnLaunchInVPC.getSelection()) {
                    if (CreateInstanceDialog.this.cmbSubnet.getItemCount() == 0) {
                        List<Subnet> subnets = CreateInstanceDialog.this.provider.getSubnetsByRegion((String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()));
                        if (!subnets.isEmpty()) {
                            for (Subnet subnet : subnets) {
                                CreateInstanceDialog.this.cmbSubnet.add(subnet.getSubnetId());
                                CreateInstanceDialog.this.cmbSubnet.setData(subnet.getSubnetId(), (Object)subnet);
                            }
                            CreateInstanceDialog.this.cmbSubnet.select(0);
                            CreateInstanceDialog.this.lblAvailabilityZone.setEnabled(false);
                            CreateInstanceDialog.this.cmbAvailabilityZone.setEnabled(false);
                            CreateInstanceDialog.this.lblSubnet.setEnabled(true);
                            CreateInstanceDialog.this.cmbSubnet.setEnabled(true);
                        } else {
                            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)CreateInstanceDialog.this.msgSubnetDoesNotExists);
                            CreateInstanceDialog.this.btnLaunchInVPC.setSelection(false);
                        }
                    } else {
                        CreateInstanceDialog.this.lblAvailabilityZone.setEnabled(false);
                        CreateInstanceDialog.this.cmbAvailabilityZone.setEnabled(false);
                        CreateInstanceDialog.this.lblSubnet.setEnabled(true);
                        CreateInstanceDialog.this.cmbSubnet.setEnabled(true);
                    }
                } else {
                    CreateInstanceDialog.this.lblAvailabilityZone.setEnabled(true);
                    CreateInstanceDialog.this.cmbAvailabilityZone.setEnabled(true);
                    CreateInstanceDialog.this.lblSubnet.setEnabled(false);
                    CreateInstanceDialog.this.cmbSubnet.setEnabled(false);
                }
            }
        });
        this.btnLaunchInVPC.setAlignment(131072);
        this.btnLaunchInVPC.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)grpInstacneInfo, 0);
        this.lblSubnet = new Label((Composite)grpInstacneInfo, 0);
        this.lblSubnet.setEnabled(false);
        this.lblSubnet.setAlignment(131072);
        this.lblSubnet.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblSubnet.setText(this.strSubnet + this.strSeparator);
        this.cmbSubnet = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbSubnet.setEnabled(false);
        this.cmbSubnet.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblKeyPair = new Label((Composite)grpInstacneInfo, 131072);
        lblKeyPair.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblKeyPair.setText(this.strKeyPair + this.strSeparator);
        this.cmbKeyPair = new Combo((Composite)grpInstacneInfo, 8);
        GridData gd_cmbKeyPair = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_cmbKeyPair.widthHint = 100;
        this.cmbKeyPair.setLayoutData((Object)gd_cmbKeyPair);
        this.ctdcKeyPair = new ControlDecoration((Control)this.cmbKeyPair, 16512);
        this.ctdcKeyPair.setImage(ResourceManager.getPluginImage((String)Activator.ID, (String)"icons/error.gif"));
        this.lblAMI = new Label((Composite)grpInstacneInfo, 0);
        this.lblAMI.setAlignment(131072);
        this.lblAMI.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblAMI.setText(this.strAmi + this.strSeparator);
        this.txtAMI = new Text((Composite)grpInstacneInfo, 2056);
        this.txtAMI.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSelectAMI = new Button((Composite)grpInstacneInfo, 0);
        this.btnSelectAMI.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnSelectAMI.setText(this.strRefer);
        this.btnSelectAMI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectAMIDialog dialog = new SelectAMIDialog(CreateInstanceDialog.this.shell);
                dialog.setCloudInfoProvider(CreateInstanceDialog.this.provider);
                dialog.setRegion((String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()));
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    Image image = dialog.getOutput();
                    CreateInstanceDialog.this.txtAMI.setText("(" + image.getImageId() + ") " + image.getName());
                    CreateInstanceDialog.this.txtAMI.setData((Object)image);
                }
            }
        });
        this.lblUseTemplate = new Label((Composite)grpInstacneInfo, 0);
        this.lblUseTemplate.setAlignment(131072);
        this.lblUseTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblUseTemplate.setText(this.strUseTemplate + this.strSeparator);
        this.btnUseTemplate = new Button((Composite)grpInstacneInfo, 32);
        this.btnUseTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUseTemplate.setAlignment(131072);
        this.btnUseTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInstanceDialog.this.btnUseTemplate.getSelection()) {
                    if (CreateInstanceDialog.this.cmbTemplate.getItemCount() == 0) {
                        for (ICloudTemplate tmpTemplate : CreateInstanceDialog.this.cloudTemplateManager.getCloudTemplates()) {
                            if (!tmpTemplate.getRegion().equals(CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()))) continue;
                            String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                            CreateInstanceDialog.this.cmbTemplate.add(tmpLabel);
                            CreateInstanceDialog.this.cmbTemplate.setData(tmpLabel, (Object)tmpTemplate);
                        }
                    }
                    if (CreateInstanceDialog.this.cmbTemplate.getItemCount() > 0) {
                        CreateInstanceDialog.this.cmbTemplate.select(0);
                        CreateInstanceDialog.this.lblTemplate.setEnabled(true);
                        CreateInstanceDialog.this.cmbTemplate.setEnabled(true);
                        CreateInstanceDialog.this.btnEditArgument.setEnabled(true);
                        CreateInstanceDialog.this.lblAMI.setEnabled(false);
                        CreateInstanceDialog.this.txtAMI.setEnabled(false);
                        CreateInstanceDialog.this.btnSelectAMI.setEnabled(false);
                        CreateInstanceDialog.this.txtAMI.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)CreateInstanceDialog.this.msgTemplateDoesNotExists);
                        CreateInstanceDialog.this.btnUseTemplate.setSelection(false);
                    }
                } else {
                    CreateInstanceDialog.this.lblTemplate.setEnabled(false);
                    CreateInstanceDialog.this.cmbTemplate.setEnabled(false);
                    CreateInstanceDialog.this.btnEditArgument.setEnabled(false);
                    CreateInstanceDialog.this.lblAMI.setEnabled(true);
                    CreateInstanceDialog.this.txtAMI.setEnabled(true);
                    CreateInstanceDialog.this.btnSelectAMI.setEnabled(true);
                    if (CreateInstanceDialog.this.txtAMI.getText().equals("")) {
                        CreateInstanceDialog.this.txtAMI.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                    }
                }
            }
        });
        new Label((Composite)grpInstacneInfo, 0);
        this.lblTemplate = new Label((Composite)grpInstacneInfo, 0);
        this.lblTemplate.setEnabled(false);
        this.lblTemplate.setAlignment(131072);
        this.lblTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblTemplate.setText(this.strTemplate + this.strSeparator);
        this.cmbTemplate = new Combo((Composite)grpInstacneInfo, 2056);
        this.cmbTemplate.setEnabled(false);
        GridData gd_cmbTemplate = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbTemplate.widthHint = 100;
        this.cmbTemplate.setLayoutData((Object)gd_cmbTemplate);
        this.btnEditArgument = new Button((Composite)grpInstacneInfo, 0);
        this.btnEditArgument.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEditArgument.setText(this.strEditArgument);
        this.btnEditArgument.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInstanceDialog.this.cmbTemplate.getText().equals("")) {
                    return;
                }
                ICloudTemplate tmpTemplate = (ICloudTemplate)CreateInstanceDialog.this.cmbTemplate.getData(CreateInstanceDialog.this.cmbTemplate.getText());
                if (tmpTemplate == null || tmpTemplate.getLaunchJobId() == null || tmpTemplate.getLaunchJobId().equals("")) {
                    return;
                }
                EditTemplateJobArgumentDialog dialog = new EditTemplateJobArgumentDialog(CreateInstanceDialog.this.shell, CreateInstanceDialog.this.cloudTemplateManager.getAccountResource().getAccountResourceId(), tmpTemplate.getTemplateId(), tmpTemplate.getLaunchJobId());
                if (dialog.open() == 0) {
                    CreateInstanceDialog.this.arguments = dialog.getArguments();
                }
            }
        });
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        Button btnDetailSettings = new Button((Composite)grpInstacneInfo, 0);
        btnDetailSettings.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnDetailSettings.setText(this.strDetailSettings);
        btnDetailSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceDetailDialog dialog = new InstanceDetailDialog(CreateInstanceDialog.this.shell);
                dialog.setCloudInfoProvider(CreateInstanceDialog.this.provider);
                CreateInstanceDialog.this.output.setRegionName((String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()));
                CreateInstanceDialog.this.output.setFacilityName(CreateInstanceDialog.this.facilityName.getText());
                if (CreateInstanceDialog.this.btnLaunchInVPC.getSelection()) {
                    CreateInstanceDialog.this.output.setSubnet((Subnet)CreateInstanceDialog.this.cmbSubnet.getData(CreateInstanceDialog.this.cmbSubnet.getText()));
                } else {
                    CreateInstanceDialog.this.output.setSubnet(null);
                }
                dialog.setInput(CreateInstanceDialog.this.output);
                if (dialog.open() == 0) {
                    CreateInstanceDialog.this.output = dialog.getOutput();
                }
            }
        });
        this.checkKeyPair();
        ControlUtil.setRequired((Control[])new Control[]{this.facilityId, this.facilityName, this.nodeName, this.txtAMI});
        this.behavior.setInput(this.input);
        this.behavior.setProvider(this.provider);
        this.behavior.setupFacilityId(this.facilityId);
        this.behavior.setupReplaceNode(this.btnReplaceNode);
        this.behavior.setupFacilityName(this.facilityName);
        this.behavior.setupDescription(this.description);
        this.behavior.setupNodeName(this.nodeName);
        this.behavior.setupRegion(this.cmbRegion);
        this.behavior.setupAvailabilityZone(this.cmbAvailabilityZone);
        this.behavior.setupDetailSettings(btnDetailSettings);
        this.behavior.setupAmi(this.txtAMI, this.btnSelectAMI);
        this.behavior.setupTemplate(this.btnUseTemplate, this.cmbTemplate, this.btnEditArgument);
        this.behavior.setupKeyPair(this.cmbKeyPair);
        container.layout();
        Control[] labels = new Control[]{lblid, lblFacilityName, lblDescription, lblNodeName, lblRegion, this.lblAvailabilityZone, this.lblLaunchInVPC, this.lblSubnet, lblKeyPair, this.lblAMI, this.lblUseTemplate, this.lblTemplate};
        int maxWidth = 0;
        for (Control l : labels) {
            Point p = l.getSize();
            maxWidth = Math.max(maxWidth, p.x);
        }
        for (Control l : labels) {
            ((GridData)l.getLayoutData()).widthHint = maxWidth;
        }
        grpNodeInfo.layout(true);
        grpInstacneInfo.layout(true);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 690);
    }

    protected void okPressed() {
        if (this.facilityId.getText().equals("") || this.facilityName.getText().equals("") || this.nodeName.getText().equals("") || this.cmbRegion.getText().equals("") || this.cmbKeyPair.getText().equals("") || !this.btnLaunchInVPC.getSelection() && this.cmbAvailabilityZone.getText().equals("") || this.btnLaunchInVPC.getSelection() && this.cmbSubnet.getText().equals("") || !this.btnUseTemplate.getSelection() && this.txtAMI.getText().equals("") || this.btnUseTemplate.getSelection() && this.cmbTemplate.getText().equals("")) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        this.output.setRegionName((String)this.cmbRegion.getData(this.cmbRegion.getText()));
        this.output.setFacilityId(this.facilityId.getText());
        this.output.setFacilityName(this.facilityName.getText());
        this.output.setDescription(this.description.getText());
        this.output.setNodeName(this.nodeName.getText());
        this.output.setKeyName(this.cmbKeyPair.getText());
        this.output.setImage((Image)this.txtAMI.getData());
        this.output.setReplaceNode(this.btnReplaceNode.getSelection());
        if (!this.btnLaunchInVPC.getSelection()) {
            this.output.setAvailabilityZone(new AvailabilityZone());
            this.output.getAvailabilityZone().setZoneName(this.cmbAvailabilityZone.getText());
            this.output.setSubnet(null);
        } else {
            this.output.setAvailabilityZone(null);
            this.output.setSubnet((Subnet)this.cmbSubnet.getData(this.cmbSubnet.getText()));
        }
        if (!this.btnUseTemplate.getSelection()) {
            this.output.setImage((Image)this.txtAMI.getData());
            this.output.templateId = null;
        } else {
            this.output.templateId = ((ICloudTemplate)this.cmbTemplate.getData(this.cmbTemplate.getText())).getTemplateId();
            Image image = new Image();
            image.setImageId(((ICloudTemplate)this.cmbTemplate.getData(this.cmbTemplate.getText())).getImageId());
            this.output.setImage(image);
            if (this.arguments != null && this.arguments.size() > 0) {
                this.output.arguments = this.arguments;
            }
            this.output.isTemplateUsed = true;
            this.output.setImage(null);
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strCreateInstanceDialog);
    }

    public void setInput(Model input) {
        assert (input != null);
        this.input = input;
        this.output = input.deepCopy();
    }

    public Model getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public void checkKeyPair() {
        if (this.cmbKeyPair.getItemCount() > 0) {
            this.ctdcKeyPair.hide();
            this.ctdcKeyPair.setDescriptionText("");
            this.ctdcKeyPair.showHoverText("");
            this.ctdcKeyPair.setShowHover(false);
        } else {
            this.ctdcKeyPair.show();
            this.ctdcKeyPair.setShowHover(true);
            this.ctdcKeyPair.setDescriptionText(this.msgThatRegionHasNoKeypair);
            this.ctdcKeyPair.showHoverText(this.msgThatRegionHasNoKeypair);
        }
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        protected MessageManagerExt messages = MessageManagerExt.getInstance("messages");
        protected CloudResourceProvider provider;
        protected Model input;

        @Override
        public void setInput(Model input) {
            this.input = input;
        }

        @Override
        public void setProvider(CloudResourceProvider provider) {
            this.provider = provider;
        }

        @Override
        public void setupFacilityId(Text facilityId) {
        }

        @Override
        public void setupFacilityName(Text facilityName) {
        }

        @Override
        public void setupReplaceNode(Button btnReplaceNode) {
        }

        @Override
        public void setupDescription(Text description) {
        }

        @Override
        public void setupNodeName(Text nodeName) {
        }

        @Override
        public void setupRegion(Combo region) {
        }

        @Override
        public void setupAvailabilityZone(Combo availabilityZone) {
        }

        @Override
        public void setupKeyPair(Combo keyPair) {
        }

        @Override
        public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
        }

        @Override
        public void setupAmi(Text ami, Button selectAmi) {
        }

        @Override
        public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
        }

        @Override
        public void setupDetailSettings(Button detailSettings) {
        }
    }

    static interface IDialogBehavior {
        public void setInput(Model var1);

        public void setProvider(CloudResourceProvider var1);

        public void setupFacilityId(Text var1);

        public void setupFacilityName(Text var1);

        public void setupReplaceNode(Button var1);

        public void setupDescription(Text var1);

        public void setupNodeName(Text var1);

        public void setupRegion(Combo var1);

        public void setupAvailabilityZone(Combo var1);

        public void setupKeyPair(Combo var1);

        public void setupSelectImageFlg(Button var1, Button var2);

        public void setupAmi(Text var1, Button var2);

        public void setupTemplate(Button var1, Combo var2, Button var3);

        public void setupDetailSettings(Button var1);
    }

    public static class Model
    extends CreateCloudInstanceRequest
    implements Serializable {
        private static final long serialVersionUID = -8364801407665470030L;
        private String regionName;
        private String templateId;
        private List<TemplateJobsArgument> arguments;
        private Boolean isTemplateUsed = false;
        private Subnet subnet;
        private AvailabilityZone availabilityZone;
        private Image image;
        private String keyName;
        private String instanceInitiatedShutdownBehavior;
        private Boolean monitoring;
        private Boolean disableApiTermination;
        private List<GroupIdentifier> securityGroups;
        private Boolean ebsOptimized;
        private EbsBlockDevice rootBlockDevice;

        public String getRegionName() {
            return this.regionName;
        }

        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public List<TemplateJobsArgument> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<TemplateJobsArgument> arguments) {
            this.arguments = arguments;
        }

        public Boolean isTemplateUsed() {
            return this.isTemplateUsed;
        }

        public void setIsTemplateUsed(Boolean isTemplateUsed) {
            this.isTemplateUsed = isTemplateUsed;
        }

        public Subnet getSubnet() {
            return this.subnet;
        }

        public void setSubnet(Subnet subnet) {
            this.subnet = subnet;
        }

        public AvailabilityZone getAvailabilityZone() {
            return this.availabilityZone;
        }

        public void setAvailabilityZone(AvailabilityZone availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public Boolean getMonitoring() {
            return this.monitoring;
        }

        public void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        public Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        public void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public List<GroupIdentifier> getSecurityGroups() {
            return this.securityGroups;
        }

        public void setSecurityGroups(List<GroupIdentifier> securityGroups) {
            this.securityGroups = securityGroups;
        }

        public Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public EbsBlockDevice getRootBlockDevice() {
            return this.rootBlockDevice;
        }

        public void setRootBlockDevice(EbsBlockDevice rootBlockDevice) {
            this.rootBlockDevice = rootBlockDevice;
        }

        public Model deepCopy() {
            return this;
        }
    }

    public static class InstanceDetail {
        public String subnetId;
        public List<String> securityGroupIds = new ArrayList<String>();
        public String keyName;
        public Boolean monitoring;
        public Boolean disableApiTermination;
        public String instanceInitiatedShutdownBehavior;
        public Boolean ebsOptimized;
        public EbsBlockDevice rootBlockDevice;
    }

    public static class EbsBlockDevice {
        public Integer volumeSize;
        public Boolean deleteOnTermination;
        public String volumeType;
        public Integer iops;
    }
}

