package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.sql.Timestamp;
import java.util.List;


/**
 * The persistent class for the cc_crun_session database table.
 * 
 */
@Entity
@Table(name="cc_crun_session")
public class CrunSessionEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String sessionId;
	private String commandId;
	private Integer endAbnomalCnt;
	private Timestamp endDate;
	private Integer endNomalCnt;
	private Integer endWarningCnt;
	private String facilityId;
	private Integer nodeCnt;
	private Integer runningCnt;
	private String scopeText;
	private Timestamp startDate;
	private Integer status;
	private String typeId;
	private Integer waitCnt;
	private List<CrunSessionDetailEntity> crunSessionDetailEntities;
	private List<CrunSessionParamEntity> crunSessionParamEntities;

	@Deprecated
	public CrunSessionEntity() {
	}

	public CrunSessionEntity(String sessionId) {
		this.setSessionId(sessionId);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
	}

	@Id
	@Column(name="session_id")
	public String getSessionId() {
		return this.sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}


	@Column(name="command_id")
	public String getCommandId() {
		return this.commandId;
	}

	public void setCommandId(String commandId) {
		this.commandId = commandId;
	}


	@Column(name="end_abnomal_cnt")
	public Integer getEndAbnomalCnt() {
		return this.endAbnomalCnt;
	}

	public void setEndAbnomalCnt(Integer endAbnomalCnt) {
		this.endAbnomalCnt = endAbnomalCnt;
	}


	@Column(name="end_date")
	public Timestamp getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Timestamp endDate) {
		this.endDate = endDate;
	}


	@Column(name="end_nomal_cnt")
	public Integer getEndNomalCnt() {
		return this.endNomalCnt;
	}

	public void setEndNomalCnt(Integer endNomalCnt) {
		this.endNomalCnt = endNomalCnt;
	}


	@Column(name="end_warning_cnt")
	public Integer getEndWarningCnt() {
		return this.endWarningCnt;
	}

	public void setEndWarningCnt(Integer endWarningCnt) {
		this.endWarningCnt = endWarningCnt;
	}


	@Column(name="facility_id")
	public String getFacilityId() {
		return this.facilityId;
	}

	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}


	@Column(name="node_cnt")
	public Integer getNodeCnt() {
		return this.nodeCnt;
	}

	public void setNodeCnt(Integer nodeCnt) {
		this.nodeCnt = nodeCnt;
	}


	@Column(name="running_cnt")
	public Integer getRunningCnt() {
		return this.runningCnt;
	}

	public void setRunningCnt(Integer runningCnt) {
		this.runningCnt = runningCnt;
	}


	@Column(name="scope_text")
	public String getScopeText() {
		return this.scopeText;
	}

	public void setScopeText(String scopeText) {
		this.scopeText = scopeText;
	}


	@Column(name="start_date")
	public Timestamp getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Timestamp startDate) {
		this.startDate = startDate;
	}


	public Integer getStatus() {
		return this.status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}


	@Column(name="type_id")
	public String getTypeId() {
		return this.typeId;
	}

	public void setTypeId(String typeId) {
		this.typeId = typeId;
	}


	@Column(name="wait_cnt")
	public Integer getWaitCnt() {
		return this.waitCnt;
	}

	public void setWaitCnt(Integer waitCnt) {
		this.waitCnt = waitCnt;
	}


	//bi-directional many-to-one association to CrunSessionDetailEntity
	@OneToMany(mappedBy="crunSessionEntity", cascade=CascadeType.ALL, orphanRemoval=true)
	public List<CrunSessionDetailEntity> getCrunSessionDetailEntities() {
		return this.crunSessionDetailEntities;
	}

	public void setCrunSessionDetailEntities(List<CrunSessionDetailEntity> crunSessionDetailEntities) {
		this.crunSessionDetailEntities = crunSessionDetailEntities;
	}


	//bi-directional many-to-one association to CrunSessionParamEntity
	@OneToMany(mappedBy="crunSessionEntity", cascade=CascadeType.ALL, orphanRemoval=true)
	public List<CrunSessionParamEntity> getCrunSessionParamEntities() {
		return this.crunSessionParamEntities;
	}

	public void setCrunSessionParamEntities(List<CrunSessionParamEntity> crunSessionParamEntities) {
		this.crunSessionParamEntities = crunSessionParamEntities;
	}

}