package com.clustercontrol.monitor.plugin.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.monitor.plugin.bean.PluginCheckInfo;
import com.clustercontrol.monitor.plugin.model.MonitorPluginInfoEntity;
import com.clustercontrol.monitor.plugin.util.QueryUtil;
import com.clustercontrol.monitor.run.factory.SelectMonitor;

public class SelectMonitorPlugin extends SelectMonitor {

	private static Log m_log = LogFactory.getLog( SelectMonitorPlugin.class );
	
	@Override
	protected PluginCheckInfo getPluginCheckInfo() throws MonitorNotFound {

		// 監視情報を取得
		MonitorPluginInfoEntity entity = QueryUtil.getMonitorPluginInfoPK(m_monitorId);

		PluginCheckInfo plugin = new PluginCheckInfo();
		plugin.setMonitorTypeId(m_monitorTypeId);
		plugin.setMonitorId(m_monitorId);

		return plugin;
	}
}
