/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtils {
    public static <T> T newInstance(Class<T> type, Object ... parameters) {
        try {
            return ReflectionUtils.invokeConstructor(ReflectionUtils.getConstructor(type, parameters), parameters);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T invokeConstructor(Constructor<T> constructor, Object ... parameters) {
        try {
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            return ReflectionUtils.throwThrowable(e.getCause());
        }
        catch (Exception e) {
            return ReflectionUtils.throwThrowable(e);
        }
    }

    public static Object invokeMethod(Object target, Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            return method.invoke(target, parameters);
        }
        catch (IllegalAccessException e) {
            return ReflectionUtils.throwThrowable(e);
        }
        catch (InvocationTargetException e) {
            return ReflectionUtils.throwThrowable(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Object ... parameters) throws NoSuchMethodException {
        return ReflectionUtils.getConstructor(type, ReflectionUtils.getTypes(parameters));
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> result = null;
        boolean ambiguous = false;
        for (Constructor<T> constructor : ReflectionUtils.getConstructors(type)) {
            if (!ReflectionUtils.match(constructor.getParameterTypes(), parameterTypes)) continue;
            if (result == null || ReflectionUtils.isMoreSpecific(constructor.getParameterTypes(), result.getParameterTypes())) {
                result = constructor;
                ambiguous = false;
                continue;
            }
            if (ReflectionUtils.isMoreSpecific(constructor.getParameterTypes(), result.getParameterTypes()) || ReflectionUtils.isMoreSpecific(result.getParameterTypes(), constructor.getParameterTypes())) continue;
            ambiguous = true;
        }
        if (ambiguous) {
            throw new InstantiationError("ambigious constructors for parameters " + Arrays.asList(parameterTypes));
        }
        if (result == null) {
            throw new NoSuchMethodException("<init>(" + Arrays.toString(parameterTypes) + ") of " + type.getName());
        }
        return result;
    }

    public static Object getFieldValue(Field field, Object target) {
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            return ReflectionUtils.throwThrowable(e);
        }
    }

    public static void setFieldValue(Field field, Object target, Object value) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.throwThrowable(e);
        }
        catch (NullPointerException e) {
            throw e;
        }
    }

    public static <T> T throwThrowable(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof InvocationTargetException) {
            return ReflectionUtils.throwThrowable(((InvocationTargetException)throwable).getTargetException());
        }
        throw new SecurityException(throwable);
    }

    private static <T> Constructor<T>[] getConstructors(Class<T> type) {
        return type.getDeclaredConstructors();
    }

    private static Class<?>[] getTypes(Object[] parameters) {
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        return types;
    }

    private static boolean match(Class<?>[] parameterTypes, Class<?>[] callingTypes) {
        if (parameterTypes.length != callingTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (callingTypes[i] == null || parameterTypes[i].isAssignableFrom(callingTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isMoreSpecific(Class<?>[] specificParameterTypes, Class<?>[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(specificParameterTypes[i])) continue;
            return false;
        }
        return true;
    }
}

