/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.criteria.CommonAbstractCriteria;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class CommonAbstractCriteriaImpl<T>
implements CommonAbstractCriteria {
    protected Metamodel metamodel;
    protected Expression<Boolean> where;
    protected CriteriaBuilderImpl queryBuilder;
    protected Class queryType;
    protected Set<ParameterExpression<?>> parameters;

    public CommonAbstractCriteriaImpl(Metamodel metamodel, CriteriaBuilderImpl queryBuilder, Class<T> resultType) {
        this.metamodel = metamodel;
        this.queryBuilder = queryBuilder;
        this.queryType = resultType;
    }

    @Override
    public Predicate getRestriction() {
        if (this.where == null) {
            return null;
        }
        if (((ExpressionImpl)this.where).isPredicate()) {
            return (Predicate)this.where;
        }
        return this.queryBuilder.isTrue(this.where);
    }

    public Class<T> getResultType() {
        return this.queryType;
    }

    public Root internalFrom(EntityType entity) {
        RootImpl root = new RootImpl(entity, this.metamodel, entity.getBindableJavaType(), (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder(entity.getBindableJavaType()), (Bindable)entity);
        this.integrateRoot(root);
        return root;
    }

    public Root internalFrom(Class entityClass) {
        EntityType entity = this.metamodel.entity(entityClass);
        return this.internalFrom(entity);
    }

    public CommonAbstractCriteria where(Expression<Boolean> restriction) {
        this.findRootAndParameters(restriction);
        this.where = restriction;
        return this;
    }

    public CommonAbstractCriteria where(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            this.where = null;
        }
        Predicate predicate = this.queryBuilder.and(restrictions);
        this.findRootAndParameters(predicate);
        this.where = predicate;
        return this;
    }

    @Override
    public <U> Subquery<U> subquery(Class<U> type) {
        return new SubQueryImpl(this.metamodel, type, this.queryBuilder, this);
    }

    protected abstract void integrateRoot(RootImpl var1);

    protected void findRootAndParameters(Expression<?> predicate) {
        ((InternalSelection)((Object)predicate)).findRootAndParameters(this);
    }

    protected abstract org.eclipse.persistence.expressions.Expression getBaseExpression();

    public void addParameter(ParameterExpression<?> parameter) {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        this.parameters.add(parameter);
    }

    protected abstract DatabaseQuery getDatabaseQuery();

    public Set<ParameterExpression<?>> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        return this.parameters;
    }

    public DatabaseQuery translate() {
        DatabaseQuery query = this.getDatabaseQuery();
        for (ParameterExpression<?> parameter : this.getParameters()) {
            query.addArgument(((ParameterExpressionImpl)parameter).getInternalName(), parameter.getJavaType());
        }
        if (this.where != null) {
            if (((InternalExpression)((Object)this.where)).isPredicate() && ((InternalSelection)((Object)this.where)).getCurrentNode() == null) {
                if (((PredicateImpl)this.where).getOperator() == Predicate.BooleanOperator.OR) {
                    query.setSelectionCriteria(new ConstantExpression(1, this.getBaseExpression()).equal(0));
                }
            } else {
                query.setSelectionCriteria(((InternalSelection)((Object)this.where)).getCurrentNode());
            }
        }
        return query;
    }
}

