/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.presenter.IInstance.StateType;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.StartInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.InstancesView2;
import com.clustercontrol.util.Messages;

public class StartInstanceAction extends MultiSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.StartInstanceAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
	
	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		Iterator<?> iter = selection.iterator();
		while (iter.hasNext()) {
			IInstance ec2Instance = (IInstance)iter.next();
			
			if (IInstance.StateType.stopped != ec2Instance.getState()) {
				return false;
			}
		}
		
		return true;
	}

	@Override
	protected void invoke(IAction action) {
		ITemplateManagement templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
		IInstance tmpInstance = null;
		StringBuffer sb = new StringBuffer();
		String confirmMessage = "";
		StartInstanceDialog.DialogOutput output = null;
		if(((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).size() > 1){
			Iterator<?> iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
			int i = 0;
			while (iter.hasNext()) {
				IInstance instance = (IInstance)iter.next();
				sb.append(bundle_view_label.getString("view.instance.column.facility_id") + " = " + instance.getFacilityId() + ", "  + bundle_view_label.getString("view.instance.column.instance_id") + " = " + instance.getInstanceId()); 
				if(iter.hasNext()) sb.append(", ");
				i++;
				if(i > 10){
					sb.append("\n");
					i = 0;
				}
			}
			confirmMessage = bundle_messages.getString("views.actions.start_instance_confirm2")+"\n"+sb;
		} else {
			tmpInstance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
			sb.append(bundle_view_label.getString("view.instance.column.facility_id") + " = " + tmpInstance.getFacilityId() + ", " + bundle_view_label.getString("view.instance.column.instance_id") + " = " + tmpInstance.getInstanceId()); 
			StartInstanceDialog dialog = new StartInstanceDialog(viewPart.getSite().getShell());
			StartInstanceDialog.DialogInput input = new StartInstanceDialog.DialogInput();
			input.setInstanceId(tmpInstance.getInstanceId());
			input.setRegion(tmpInstance.getRegion().getRegionName());
			if(tmpInstance.getTemplateId() != null && !tmpInstance.getTemplateId().equals("")){
				input.setTemplateId(tmpInstance.getTemplateId());
			}
			dialog.setInput(input);
			if(dialog.open() == Window.OK){
				output = dialog.getOutput();
			} else {
				return;
			}
			confirmMessage = bundle_messages.getString("views.actions.start_instance_confirm")+"\n"+sb;
		}
		
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			confirmMessage)){

			if(tmpInstance == null){
				Iterator<?> iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
				while (iter.hasNext()) {
					tmpInstance = (IInstance)iter.next();
					if(tmpInstance.getTemplateId() != null && !tmpInstance.getTemplateId().equals("")){
						ITemplate template = templateManagement.getTemplate(tmpInstance.getTemplateId());
						tmpInstance.start(true, template.getStartJobId(), null);
					} else {
						tmpInstance.start();
					}
				}
			} else {
				tmpInstance.start(output.getRunJobFlg(), output.getJobId(), output.getArguments());
			}

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.start_instance_result"));

			final Iterator<?> iter2 = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
			final InstancesView2 view = (InstancesView2)viewPart;
			view.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					while (iter2.hasNext()) {
						InstanceMonitorService.getInstanceMonitorService().startMonitor((IInstance)iter2.next(), StateType.running);
					}
				}
			});
		}
	}
}