/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstanceBackup;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IInstance.StateType;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;


public class RestoreInstanceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RestoreInstance";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	@Override
	protected void invoke(IAction action) throws InvocationException {
		CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());

		IInstanceBackup backup = (IInstanceBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		String region = backup.getRegion();
		if (region != null) {
			CreateInstanceDialog.Model m = new CreateInstanceDialog.Model();
			m.regionName = region;
			m.availabilityZone = new AvailabilityZone();
			m.availabilityZone.setZoneName(backup.getAvailabilityZone());
			m.facilityId = backup.getFacilityId();
			m.facilityName = backup.getFacilityName();
			m.keyName = backup.getKeyName();
			m.nodeName = backup.getNodeName();
			m.replaceNode = true;
			m.image = new Image();
			m.image.setImageId(backup.getImageId());
			m.image.setName(backup.getImageName());
			m.description = backup.getDescription();
			dialog.setInput(m);
		}

		final CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
		dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
		dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
			@Override
			public void setupFacilityId(Text facilityId) {
				facilityId.setText(input.facilityId);
			}

			@Override
			public void setupFacilityName(Text facilityName) {
				if(input.facilityName != null){
					facilityName.setText(input.facilityName);
				}
			}

			@Override
			public void setupReplaceNode(Button btnReplaceNode) {
				btnReplaceNode.setSelection(true);
			}

			@Override
			public void setupDescription(Text description) {
				if(input.description != null){
					description.setText(input.description);
				}
			}

			@Override
			public void setupNodeName(Text nodeName) {
				nodeName.setText(input.nodeName);
			}

			@Override
			public void setupRegion(Combo region) {
				String regionLocaleName = bundle_region.getString(input.regionName);
				region.add(regionLocaleName);
				region.setData(regionLocaleName, input.regionName);
				region.select(0);
				region.setEnabled(false);
			}

			@Override
			public void setupAvailabilityZone(Combo availabilityZone) {
				for (AvailabilityZone zone: provider.getAvailabilityZones(input.regionName)){
					availabilityZone.add(zone.getZoneName());
				}
				if(availabilityZone.indexOf(input.availabilityZone.getZoneName()) != -1){
					availabilityZone.select(availabilityZone.indexOf(input.availabilityZone.getZoneName()));
				} else {
					availabilityZone.select(0);
				}
			}

			@Override
			public void setupKeyPair(Combo keyPair) {
				for(String keyName: provider.getKeyNames(input.regionName)){
					keyPair.add(keyName);
				}
				if(keyPair.getItemCount() > 0){
					if(keyPair.indexOf(input.keyName) != -1){
						keyPair.select(keyPair.indexOf(input.keyName));				
					} else {
						keyPair.select(0);
					}
					keyPair.setEnabled(true);
				} else {
					keyPair.setEnabled(false);
				}
			}

			@Override
			public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate){
				rdoAmi.setSelection(true);
				rdoAmi.setEnabled(false);
				rdoTemplate.setSelection(false);
				rdoTemplate.setEnabled(false);
			}
			
			@Override
			public void setupAmi(Text ami, Button selectAmi) {
				ami.setText("(" + input.image.getImageId() + ") "+ input.image.getName());
				ami.setData(input.image);
//				ami.setEnabled(false);
				ami.setEditable(false);
				selectAmi.setEnabled(false);
			}
			
			@Override
			public void setupTemplate(Button useTemplate, Combo template, Button editArgument){
				useTemplate.setEnabled(false);
				template.setEnabled(false);
				editArgument.setEnabled(false);
			}
		});
		
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.create_instance_confirm"))){

				CreateInstanceDialog.Model m = dialog.getOutput();
				IRegion r = backup.getInstanceBackupRoot().getBackupManagement().getRegion();
				final IInstance instance = r.getInstanceRoot().restore(m);

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_instance_result"));
				
				viewPart.getSite().getShell().getDisplay().asyncExec(new Runnable() {
					@Override
					public void run() {
						InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, StateType.running, StateType.terminated, StateType.stopped);
						com.clustercontrol.action.FacilityTree.reflesh();
					}
				});
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		IInstanceBackup backup = (IInstanceBackup)((IStructuredSelection)selection).getFirstElement();
		if(backup == null || backup.getExistsStatus() == null || backup.getExistsStatus() == IInstanceBackup.ExistStatusType.nothing){
			action.setEnabled(false);
		}
	}
}