/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IFacilityRoot;


public class RefreshScopeAction extends AbstractViewAction {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RefreshScopeAction";

	@Override
	protected void invoke(IAction action) {
		try {
			IFacilityRoot root = Activator.getDefault().getCloudManager().getHinemosService().getFacilityRoot();
			root.update();
		}
		catch (Exception e) {
			Logger logger = Logger.getLogger(RefreshScopeAction.class);
			logger.warn(e.getMessage(), e);
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		try {
			Activator.getDefault().getCloudManager().getHinemosService().getFacilityRoot();
			action.setEnabled(true);
		}
		catch (Exception e) {
			Logger logger = Logger.getLogger(RefreshScopeAction.class);
			logger.warn(e.getMessage(), e);

			action.setEnabled(false);
		}
	}
}