/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.resources.Filter;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;


public class ModifyTemplateAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.ModifyTemplateAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 

	private final CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
	private CloudResourceProvider provider = new CloudResourceProviderImpl(endpoint);
	private ITemplate template;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		template = (ITemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
		dialog.setCloudInfoProvider(provider);
		try {
			dialog.setBehavior(new CreateTemplateDialog.DialogBehavior(){

				private MessageManager bundle_region = MessageManager.getInstance("region");
				private List<TemplateJobUtil.TemplateJobnet> templateJobs;
				{
					try{
						templateJobs = TemplateJobUtil.getTemplateJobList(true);
					} catch(com.clustercontrol.ws.jobmanagement.InvalidRole_Exception e) {
						MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
						templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
					}
				}
								
				@Override
				public void setupTemplateId(Text templateId) {
					if(template != null){
						templateId.setText(template.getTemplateId());
						templateId.setEditable(false);
					}
				}

				@Override
				public void setupTemplateName(Text templateName) {
					if(template != null && template.getTemplateName() != null && !template.getTemplateName().isEmpty()){
						templateName.setText(template.getTemplateName());
					}
				}
				@Override
				public void setupRegion(Combo region) {
					for (String regionName: provider.getAllRegion()) {
						String regionLocaleName = bundle_region.getString(regionName);
						region.add(regionLocaleName);
						region.setData(regionLocaleName, regionName);
					}
					if (template != null && template.getRegion() != null && !template.getRegion().equals("")) {
						String regionLocaleName = bundle_region.getString(template.getRegion());
						region.select(region.indexOf(regionLocaleName));
					} else {
						region.select(0);
					}
				}
				
				@Override
				public void setupAmi(Text ami, Button selectAmi) {
					if(template != null && template.getImageId() != null && !template.getImageId().equals("") && template.getRegion() != null && !template.getRegion().equals("")){
						Filter f1 = new Filter();
						f1.setName("image-id");
						f1.setValues(Arrays.asList(template.getImageId()));
	
						List<Image> imageList = provider.getImages(template.getRegion(), Arrays.asList(f1));
						if (!imageList.isEmpty()) {
							Image image = imageList.get(0);
							ami.setText("(" + image.getImageId() + ") "+ image.getName());
							ami.setData(image);
						}
					}
				}

				@Override
				public void setupLaunchJobId(Combo launchJobId){
					Map<String, String> tmpMap = new HashMap<String, String>();
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						tmpMap.put(jobId, jobName);
						launchJobId.add(jobName);
						launchJobId.setData(jobName, jobId);
					}
					if(template != null && template.getLaunchJobId() != null && !template.getLaunchJobId().equals("") && tmpMap.containsKey(template.getLaunchJobId())){
						launchJobId.select(launchJobId.indexOf(tmpMap.get(template.getLaunchJobId())));
					}
				}

				@Override
				public void setupStartJobId(Combo startJobId) {
					Map<String, String> tmpMap = new HashMap<String, String>();
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						tmpMap.put(jobId, jobName);
						startJobId.add(jobName);
						startJobId.setData(jobName, jobId);
					}
					if(template != null && template.getStartJobId() != null && !template.getStartJobId().equals("") && tmpMap.containsKey(template.getStartJobId())){
						startJobId.select(startJobId.indexOf(tmpMap.get(template.getStartJobId())));
					}
				}

				@Override
				public void setupStopJobId(Combo stopJobId) {
					Map<String, String> tmpMap = new HashMap<String, String>();
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						tmpMap.put(jobId, jobName);
						stopJobId.add(jobName);
						stopJobId.setData(jobName, jobId);
					}
					if(template != null && template.getStopJobId() != null && !template.getStopJobId().equals("") && tmpMap.containsKey(template.getStopJobId())){
						stopJobId.select(stopJobId.indexOf(tmpMap.get(template.getStopJobId())));
					}
				}
			});
		} catch (Exception e) {
			throw new InvocationException(e);
		}

		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.modify_template_confirm"))) {

				template.getTemplateManagement().modifyTemplate(template, dialog.getOutput());
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.modify_template_result"));
			}
			else {
				return;
			}
		}
	}
}