///*
//Copyright (C) 2013 NTT DATA Corporation
//
//This program is free software; you can redistribute it and/or
//Modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation, version 2.
//
//This program is distributed in the hope that it will be
//useful, but WITHOUT ANY WARRANTY; without even the implied
//warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//PURPOSE.  See the GNU General Public License for more details.
// */
//
//package com.clustercontrol.cloud.ui.views.actions;
//
//import org.eclipse.jface.action.IAction;
//import org.eclipse.jface.dialogs.MessageDialog;
//import org.eclipse.jface.viewers.ISelection;
//import org.eclipse.jface.viewers.IStructuredSelection;
//import org.eclipse.jface.window.Window;
//
//import com.clustercontrol.cloud.aws.presenter.AuthorizeIpPermissionRequest;
//import com.clustercontrol.cloud.aws.presenter.IIpPermission;
//import com.clustercontrol.cloud.aws.presenter.ISecurityGroup;
//import com.clustercontrol.cloud.commons.util.MessageManager;
//import com.clustercontrol.cloud.ui.dialogs.AddRuleDialog;
//import com.clustercontrol.cloud.ui.views.SecurityGroupDetailView;
//import com.clustercontrol.util.Messages;
//
//
//public class ModifyIpPermissionAction extends SingleSelectionActionEx {
//	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditRule";
//
//	private MessageManager bundle_messages = MessageManager.getInstance("messages");
//
//	private ISecurityGroup sg;
//	private IIpPermission ip;
//
//	@Override
//	protected void invoke(IAction action) throws InvocationException {
//		ip = (IIpPermission)((IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
//		
//		AddRuleDialog dialog = new AddRuleDialog(this.viewPart.getSite().getShell(), ip);
//		if(dialog.open() == Window.OK){
//			if (MessageDialog.openConfirm(
//				null,
//				Messages.getString("confirmed"),
//				bundle_messages.getString("views.actions.edit_rule_confirm"))){
//				try {
//					sg.revokeIpPermission(ip);
//					
//					AuthorizeIpPermissionRequest request = new AuthorizeIpPermissionRequest();
//					request.setSecurityGroupId(sg.getSecurityGroupId());
//					request.setIpProtocol(dialog.getIpProtocol());
//					request.setFromPort(dialog.getFromPort());
//					request.setToPort(dialog.getToPort());
//					request.setIpRange(dialog.getIpRange());
//					request.setSrouceSecurityGroupId(dialog.getSecurityGroupId());
//					request.setUserId(dialog.getUserId());
//					request.setSourceSecurityGroupName(dialog.getGroupName());
//					sg.authorizeIpPermission(request);
//
//					// 成功報告ダイアログを生成
//					MessageDialog.openInformation(
//						null,
//						Messages.getString("successful"),
//						bundle_messages.getString("views.actions.edit_rule_result"));
//	
//				} catch (Exception e) {
//					// 失敗報告ダイアログを生成
//					MessageDialog.openError(
//						null,
//						Messages.getString("failed"),
//						e.getMessage());
//				}
//			} else {
//				return;
//			}
//		}
//	}
//	
//	@Override
//	public void selectionChanged(IAction action, ISelection selection) {
//		super.selectionChanged(action, selection);
//		sg = ((SecurityGroupDetailView)viewPart).getSecurityGroup();
//		if(!(sg == null) && action.isEnabled()){
//			action.setEnabled(true);
//		} else {
//			action.setEnabled(false);
//		}
//	}
//}