/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IBillingAlarm;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.ChargeAlertDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;


public class ModifyBillingAlarmAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.ModifyBillingAlarmAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	@Override
	public void invoke(IAction action) {
		ChargeAlertDialog dialog = new ChargeAlertDialog(this.viewPart.getSite().getShell());

		CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
		dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));

		IBillingAlarm billingAlarm = (IBillingAlarm)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		dialog.setInput(billingAlarm);
		
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.modify_billing_alarm_confirm"))){

				billingAlarm.modify(dialog.getModifyRequest());

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.modify_billing_alarm_result"));
			}
			else {
				return;
			}
		}
	}
}