/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.commons.util.CloudClientConstants;
import com.clustercontrol.cloud.commons.util.KeyCodec;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.ShowWindowsPasswordDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;

public class GetWindowsPassAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.GetWindowsPassAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		IInstance instance = (IInstance)selection.getFirstElement();
		if (CloudClientConstants.ACTION_CONSTANTS_GET_WINDOWS_PASSWORD_TARGET_PLATFORM.equals(instance.getPlatform())) {
			return true;
		}
		return false;
	}

	@Override
	protected void invoke(IAction action) throws InvocationException {
		IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();

		if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.get_password_confirm"))){
			
			CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
			
			String password = null;
			try {
				password = endpoint.getWindowsPassword(instance.getRegion().getRegionName(), instance.getInstanceId());
			}
			catch (Exception e) {
				throw new InvocationException(e);
			}
			
			FileDialog dialog = new FileDialog(viewPart.getSite().getShell());
			String [] exts = {CloudClientConstants.ACTION_CONSTANTS_GET_WINDOWS_PASSWORD_CONSTRAINT_FILE_TYPE};
			String [] filterNames = {bundle_messages.getString("views.actions.get_password_secret_key_file") + "(" + CloudClientConstants.ACTION_CONSTANTS_GET_WINDOWS_PASSWORD_CONSTRAINT_FILE_TYPE + ")"};
			dialog.setFilterExtensions(exts);
			dialog.setFilterNames(filterNames);
			String file = dialog.open();
			
			try {
				KeyCodec codec = new KeyCodec();
				codec.setPrivateKeyFile(file);
				String decryptedPassword = new String(codec.decryptWithPrivateKey(KeyCodec.getBase64Binary(password)));

				if(decryptedPassword == null || decryptedPassword.isEmpty()){
					MessageDialog.openError(null, Messages.getString("failed"), bundle_messages.getString("views.actions.get_password_secret_key_file_different"));
					return;
				}

				ShowWindowsPasswordDialog swpDialog = new ShowWindowsPasswordDialog(viewPart.getSite().getShell());
				swpDialog.setText(decryptedPassword);
				swpDialog.open();
			} catch (Exception e) {
				throw new InvocationException(e);
			}
		}
	}
}