/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.aws.presenter.AccessKey;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.ModifyIdentityRequest;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.RegistAccountDialog;
import com.clustercontrol.util.Messages;


public class EditAccountAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditAccount";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	@Override
	protected void invoke(IAction action) {
		// 選択されている情報を抽出。
		RegistAccountDialog.Type type = null;
		IIdentity id = (IIdentity)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		if (id.getParent() != null) {
			type = RegistAccountDialog.Type.user;
		}
		else {
			type = RegistAccountDialog.Type.account;
		}

		RegistAccountDialog dialog = new RegistAccountDialog(this.viewPart.getSite().getShell(), RegistAccountDialog.Mode.modify, type);
		
		// 初期状態を設定。
		RegistAccountDialog.Model input = new RegistAccountDialog.Model();
		input.id = id.getId();
		input.name = id.getName();
		input.key = new AccessKey();
		input.key.setAccessKey(id.getAccessKey().getAccessKey());
		input.key.setSecretKey(id.getAccessKey().getSecretKey());
		input.description = id.getDescription();
		input.hinemosUserId = id.getHinemosUserId();
		input.category = id.getCategory();
		
		dialog.setInput(input);
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				type == RegistAccountDialog.Type.account ? bundle_messages.getString("views.actions.edit_account_confirm"): bundle_messages.getString("views.actions.edit_user_confirm"))
				){

				RegistAccountDialog.Model output = dialog.getOutput();
				
				ModifyIdentityRequest request = new ModifyIdentityRequest();
				request.name = output.name;
				request.description = output.description;
				request.key = output.key;
				request.hinemosUserId = output.hinemosUserId;

				id.modifyIdentity(request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					type == RegistAccountDialog.Type.account ? bundle_messages.getString("views.actions.edit_account_result"): bundle_messages.getString("views.actions.edit_user_result"));
			} else {
				return;
			}
		}
	}

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		return selection.getFirstElement() instanceof IIdentity;
	}
}