/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstance.RegistStateType;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.DetachInstanceDialog;
import com.clustercontrol.util.Messages;


public class DetachStorageAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DetachStorageAction";
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	@Override
	protected void invoke(IAction action) throws InvocationException {
		IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		DetachInstanceDialog dialog = new DetachInstanceDialog(this.viewPart.getSite().getShell(), instance);

		if(dialog.open() == Window.OK){
			StringBuffer sb = new StringBuffer();
			
			int i = 0;
			
			Iterator<String> iter = dialog.getVolumes().iterator();
			while (iter.hasNext()) {
				sb.append(iter.next());
				if(iter.hasNext()) sb.append(", ");
				i++;
				if(i > 10){
					sb.append("\n");
					i = 0;
				}
			}
	
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.detach_storage_confirm")+"\n"+sb)){

				for(String vol: dialog.getVolumes()){
					instance.detachStorage(vol);
				}

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.detach_storage_result"));
	
			} else {
				return;
			}
		}
	}
	
	protected boolean canEnabled(IStructuredSelection selection) {
		IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		if (instance.getRegistState() == RegistStateType.deleted) {
			return false;
		}
		return true;
	}
}