/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.aws.presenter.IStorage.RegistStateType;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class DetachInstanceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DetachInstanceAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	protected boolean canEnabled(IStructuredSelection selection) {
		Iterator<?> iter = selection.iterator();
		while (iter.hasNext()) {
			IStorage storage = (IStorage)iter.next();
			if (storage.getStorageAttachment() == null || storage.getRegistState() == RegistStateType.deleted) {
				return false;
			}
			break;
		}
		
		return true;
	}

	@Override
	protected void invoke(IAction action) throws InvocationException {
		StringBuffer sb = new StringBuffer();
		
		Iterator<?> iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
		int i = 0;
		while (iter.hasNext()) {
			sb.append(((IStorage)iter.next()).getStorageId());
			if(iter.hasNext()) sb.append(", ");
			i++;
			if(i > 10){
				sb.append("\n");
				i = 0;
			}
		}
		
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			bundle_messages.getString("views.actions.detach_storage_confirm")+"\n"+sb)){

			iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
			while (iter.hasNext()) {
				IStorage vol = (IStorage)iter.next();
				vol.detachInstance();
				break;
			}
			
			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.detach_storage_result"));
		}
	}
}