/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Combo;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.INode;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IScope;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.ui.views.ScopeView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;


public class CreateTemplateAction extends AbstractViewAction {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateTemplateAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private final CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
	private CloudResourceProvider provider = new CloudResourceProviderImpl(endpoint);
	private IRegion region;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		ISelection selection = viewPart.getSite().getPage().getSelection(ScopeView.Id);
		IEC2Service ec2Service;
		try {
			ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
		}
		catch (Exception e) {
			throw new InvocationException(e);
		}

		if (selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection)selection;
			if (!structuredSelection.isEmpty()) {
				
				Object selected = structuredSelection.getFirstElement();
				String facilityId = null;
				if (selected instanceof IScope) {
					IScope scope = (IScope)selected;
					switch(scope.getScopeType()) {
					case root:
						break;
					case region:
						{
							facilityId = scope.getFacilityId();
						}
						break;
					case availabilityZone:
						{
							facilityId = scope.getParent().getFacilityId();
						}
						break;
					default:
						throw new IllegalStateException();
					}
				}
				else if (selected instanceof INode) {
					INode node = (INode)selected;
					facilityId = node.getParent().getParent().getFacilityId();
				}
				if(facilityId != null){
					region = ec2Service.getRegion(facilityId);
				}
			}
		}
		
		CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
		dialog.setCloudInfoProvider(provider);
		try {
			dialog.setBehavior(new CreateTemplateDialog.DialogBehavior(){
				private MessageManager bundle_region = MessageManager.getInstance("region");
				private List<TemplateJobUtil.TemplateJobnet> templateJobs;
				{
					try{
						templateJobs = TemplateJobUtil.getTemplateJobList(true);
					} catch(com.clustercontrol.ws.jobmanagement.InvalidRole_Exception e) {
						MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
						templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
					}
				}
				private IRegion region = CreateTemplateAction.this.region;

				@Override
				public void setupRegion(Combo region) {
					for (String regionName: provider.getAllRegion()) {
						String regionLocaleName = bundle_region.getString(regionName);
						region.add(regionLocaleName);
						region.setData(regionLocaleName, regionName);
					}
					if (this.region != null) {
						String regionLocaleName = bundle_region.getString(this.region.getRegionName());
						region.select(region.indexOf(regionLocaleName));
					} else {
						region.select(0);
					}
				}

				@Override
				public void setupLaunchJobId(Combo launchJobId){
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						launchJobId.add(jobName);
						launchJobId.setData(jobName, jobId);
					}
				}

				@Override
				public void setupStartJobId(Combo startJobId) {
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						startJobId.add(jobName);
						startJobId.setData(jobName, jobId);
					}
				}

				@Override
				public void setupStopJobId(Combo stopJobId) {
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						stopJobId.add(jobName);
						stopJobId.setData(jobName, jobId);
					}
				}
			});
		} catch (Exception e) {
			throw new InvocationException(e);
		}

		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.create_template_confirm"))) {

				ITemplateManagement templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
				
				templateManagement.createTemplate(dialog.getOutput());
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_template_result"));
			}
			else {
				return;
			}
		}
	}
}