/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.presenter.IInstance.StateType;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;


public class CreateInstanceByTemplateAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateInstanceByTemplateAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 

	private ITemplateManagement templateManagement;
	private ITemplate template;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());

		final TemplatesView view = (TemplatesView)viewPart;

		template = (ITemplate)((IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		templateManagement = template.getTemplateManagement();
		String region = template.getRegion();
		CreateInstanceDialog.Model input = new CreateInstanceDialog.Model();
		input.regionName = region;
		dialog.setInput(input);

		final CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
		dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
		dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
			private Combo region;

			@Override
			public void setupRegion(Combo region) {
				for (String regionName: provider.getAllRegion()) {
					String regionLocaleName = bundle_region.getString(regionName);
					region.add(regionLocaleName);
					region.setData(regionLocaleName, regionName);
				}
				if (template != null && template.getRegion() != null) {
					String regionLocaleName = bundle_region.getString(input.regionName);
					region.select(region.indexOf(regionLocaleName));
				} else {
					region.select(0);
				}
				this.region = region;
			}

			@Override
			public void setupAvailabilityZone(Combo availabilityZone) {
				for (AvailabilityZone zone: provider.getAvailabilityZones((String)region.getData(region.getText()))) {
					availabilityZone.add(zone.getZoneName());
				}
				availabilityZone.select(0);
			}

			@Override
			public void setupKeyPair(Combo keyPair) {
				for(String keyName: provider.getKeyNames((String)region.getData(region.getText()))){
					keyPair.add(keyName);
				}
				if(keyPair.getItemCount() > 0){
					keyPair.setEnabled(true);
					keyPair.select(0);
				}
				else {
					keyPair.setEnabled(false);
				}
			}

			@Override
			public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate){
				rdoAmi.setSelection(false);
				rdoTemplate.setSelection(true);
			}

			@Override
			public void setupAmi(Text ami, Button selectAmi){
				ami.setEnabled(false);
				ami.setEditable(false);
				ami.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				selectAmi.setEnabled(false);
			}

			@Override
			public void setupTemplate(Button useTemplate, Combo template, Button editArgument){
				useTemplate.setSelection(true);
				Map<String, String> map = new HashMap<String, String>();
				for(ITemplate tmpTemplate: templateManagement.getTemplates()){
					if(tmpTemplate.getRegion().equals(region.getData(region.getText()))){
						String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
						template.add(tmpLabel);
						template.setData(tmpLabel, tmpTemplate);
						map.put(tmpTemplate.getTemplateId(), tmpLabel);
					}
				}
				if(CreateInstanceByTemplateAction.this.template != null && map.containsKey(CreateInstanceByTemplateAction.this.template.getTemplateId())){
					template.select(template.indexOf(map.get(CreateInstanceByTemplateAction.this.template.getTemplateId())));
				}
				template.setEnabled(true);
				editArgument.setEnabled(true);
			}
		});

		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.create_instance_by_template_confirm"))){

				CreateInstanceDialog.Model output = dialog.getOutput();
				IRegion r = templateManagement.getCloudResourceManager().getInventory().getFolder(IEC2Service.class).getRegion(template.getRegion());
				final IInstance instance;
				if(output.isTemplateUsed){
					instance = r.getInstanceRoot().createInstance(output, output.templateId, output.arguments);
				} else {
					instance = r.getInstanceRoot().createInstance(output);
				}

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_instance_by_template_result"));
				
				view.getSite().getShell().getDisplay().asyncExec(new Runnable() {
					@Override
					public void run() {
						InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, StateType.running, StateType.terminated, StateType.stopped);
						com.clustercontrol.action.FacilityTree.reflesh();
					}
				});
			}
			else {
				return;
			}
		}
	}
}