/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.presenter.IInstance.StateType;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.InstancesView2;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;


public class CreateInstanceAction extends AbstractViewAction {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateInstanceAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		final ITemplateManagement templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
		IEC2Service service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);

		CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
		
		final InstancesView2 view = (InstancesView2)viewPart;
		IRegion region = view.getActiveRegion();
		if (region != null) {
			CreateInstanceDialog.Model m = new CreateInstanceDialog.Model();
			m.regionName = region.getRegionName();
			if (view.getActiveZone() != null) {
				m.availabilityZone = new AvailabilityZone();
				m.availabilityZone.setZoneName(view.getActiveZone());
			}
			dialog.setInput(m);
		}

		final CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);

		dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
		dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
			private Combo region;

			@Override
			public void setupRegion(Combo region) {
				for (String regionName: provider.getAllRegion()) {
					String regionLocaleName = bundle_region.getString(regionName);
					region.add(regionLocaleName);
					region.setData(regionLocaleName, regionName);
				}
				if (input != null && input.regionName != null) {
					String regionLocaleName = bundle_region.getString(input.regionName);
					region.select(region.indexOf(regionLocaleName));
				} else {
					region.select(0);
				}
				this.region = region;
			}

			@Override
			public void setupAvailabilityZone(Combo availabilityZone) {
			}

			@Override
			public void setupKeyPair(Combo keyPair) {
			}
			
			@Override
			public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate){
				rdoAmi.setSelection(true);
				rdoTemplate.setSelection(false);
			}

			@Override
			public void setupTemplate(Button useTemplate, Combo template, Button editArgument){
				for(ITemplate tmpTemplate: templateManagement.getTemplates()){
					if(tmpTemplate.getRegion().equals(region.getData(region.getText()))){
						String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
						template.add(tmpLabel);
						template.setData(tmpLabel, tmpTemplate);
					}
				}
				template.setEnabled(false);
				editArgument.setEnabled(false);
			}
		});
		
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.create_instance_confirm"))){

				CreateInstanceDialog.Model m = dialog.getOutput();

				IRegion r = service.getRegion(m.regionName);
				final IInstance instance;
				if(m.isTemplateUsed){
					instance = r.getInstanceRoot().createInstance(m, m.templateId, m.arguments);
				} else {
					instance = r.getInstanceRoot().createInstance(m);
				}

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_instance_result"));
				
				view.getSite().getShell().getDisplay().asyncExec(new Runnable() {
					@Override
					public void run() {
						InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, StateType.running, StateType.terminated, StateType.stopped);
						com.clustercontrol.action.FacilityTree.reflesh();
					}
				});
			}
			else {
				return;
			}
		}
	}
}