/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.aws.presenter.CreateStorageBackupRequest;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageBackupDialog;
import com.clustercontrol.util.Messages;

public class BackupStorageAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.BackupStorage";

	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		IStorage storage = (IStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();

		CreateStorageBackupDialog dialog = new CreateStorageBackupDialog(this.viewPart.getSite().getShell(), storage);
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.create_snapshot_confirm"))){
				
				CreateStorageBackupRequest request = new CreateStorageBackupRequest();
				request.setSnapshotName(dialog.getName());
				request.setDescription(dialog.getDescription());
				request.setStorageId(storage.getStorageId());
				request.setRegion(storage.getRegion().getRegionName());
				storage.getStorageRoot().getRegion().getBackupManagement().getStorageBackupRoot().createStorageBackup(request);

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_snapshot_result"));
	
			} else {
				return;
			}
		}
	}
}