/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.aws.presenter.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateInstanceBackupDialog;
import com.clustercontrol.util.Messages;

public class BackupInstanceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.BackupInstance";

	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 

	@Override
	protected void invoke(IAction action) throws InvocationException {
		IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();

		CreateInstanceBackupDialog dialog = new CreateInstanceBackupDialog(this.viewPart.getSite().getShell(), instance);
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.create_image_confirm"))){

				CreateInstanceBackupRequest request = new CreateInstanceBackupRequest();
				request.setInstanceId(instance.getInstanceId());
				request.setImageName(dialog.getImageName());
				request.setDescription(dialog.getDescription());
				request.setNoReboot(dialog.getNoReboot());
				request.setWithEBSVolume(dialog.getWithEBSVolume());
				instance.getInstanceRoot().getRegion().getBackupManagement().getInstanceBackupRoot().createInstanceBackup(request);

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_image_result"));
			} else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		IInstance instance = (IInstance)((IStructuredSelection)selection).getFirstElement();
		if(instance == null || instance.getFacilityId() == null || "".equals(instance.getFacilityId()) || instance.getRegistState() == IInstance.RegistStateType.deleted){
			action.setEnabled(false);
		}
	}
}