/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.IIdentityManagement;
import com.clustercontrol.cloud.aws.presenter.ValueObserver2;


public class UsersView extends ViewPart {
	public static final String Id = "com.clustercontrol.cloud.ui.views.UsersView";
	
	private Runnable refreshness = new Runnable() {
		@Override
		public void run() {
			// 非同期でコールバックが来るので更新。
			treeViewer.refresh(true);
			
			// アクションの状態を更新。
			ISelection selection = UsersView.this.treeViewer.getSelection();
			UsersView.this.getSite().getSelectionProvider().setSelection(selection);
		}
	};

	private ValueObserver2<String> nameObserver = new ValueObserver2<String>() {
		@Override
		public void propertyChanged(ValueChangedEvent<String> event) {
			UsersView.this.getSite().getShell().getDisplay().asyncExec(refreshness);
		}
	};

	private CollectionObserver2<IIdentity> identity4Category = new CollectionObserver2<IIdentity>() {
		@Override
		public void elementAdded(ElementAddedEvent<IIdentity> event) {
			IIdentity element = event.getAddedElement();
			
			element.addPropertyObserver2(IIdentity.p2.name, nameObserver);
			element.addPropertyObserver2(IIdentity.p2.identities, identity4Identity);

			UsersView.this.getSite().getShell().getDisplay().asyncExec(refreshness);
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<IIdentity> event) {
			IIdentity element = event.getRemovedElement();
			
			// ユーザーの階層は、1 階層しかないことを前提の処理。
			for (IIdentity child: element.getIdentities()) {
				child.removePropertyObserver2(IIdentity.p2.name, nameObserver);
				child.removePropertyObserver2(IIdentity.p2.identities, identity4Identity);
			}
			
			element.removePropertyObserver2(IIdentity.p2.name, nameObserver);
			element.removePropertyObserver2(IIdentity.p2.identities, identity4Identity);

			UsersView.this.getSite().getShell().getDisplay().asyncExec(refreshness);
		}
	};
	
	private CollectionObserver2<IIdentity> identity4Identity = new CollectionObserver2<IIdentity>() {
		@Override
		public void elementAdded(ElementAddedEvent<IIdentity> event) {
			IIdentity element = event.getAddedElement();
			
			element.addPropertyObserver2(IIdentity.p2.name, nameObserver);

			UsersView.this.getSite().getShell().getDisplay().asyncExec(refreshness);
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<IIdentity> event) {
			IElement element = (IElement)event.getRemovedElement();
			
			element.removePropertyObserver2(IIdentity.p2.name, nameObserver);

			UsersView.this.getSite().getShell().getDisplay().asyncExec(refreshness);
		}
	};
	
	private class TreeContentProvider implements IStructuredContentProvider, ITreeContentProvider{
		
		public Object[] getChildren(Object parentElement) {
			if(parentElement instanceof IIdentityManagement) {
				return ((IIdentityManagement)parentElement).getCategories();
			}
			else if(parentElement instanceof ICategory) {
				return ((ICategory)parentElement).getIdentities();
			}
			else if(parentElement instanceof IIdentity) {
				return ((IIdentity)parentElement).getIdentities();
			}
			return new Object[0];
		}

		public Object getParent(Object element) {
			if(element instanceof ICategory) {
				return ((ICategory)element).getIdentityManagement();
			}
			else if(element instanceof IIdentity) {
				IIdentity id = (IIdentity)element; 
				if (id.getParent() != null) {
					return id.getParent();
				}
				else {
					return id.getCategory();
				}
			}
			return null;
		}

		public boolean hasChildren(Object element) {
			if(element instanceof IIdentityManagement) {
				return ((IIdentityManagement)element).getCategories().length != 0;
			}
			else if(element instanceof ICategory) {
				return ((ICategory)element).getIdentities().length != 0;
			}
			else if(element instanceof IIdentity) {
				return ((IIdentity)element).getIdentities().length != 0;
			}
			return false;	
		}

		public Object[] getElements(Object inputElement) {
			assert inputElement instanceof IIdentityManagement;
			return ((IIdentityManagement)inputElement).getCategories();
		}

		public void dispose() {
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
	}

	private IIdentityManagement im;

	private TreeViewer treeViewer;
	
	public UsersView() {
	}

	@Override
	public void createPartControl(Composite arg0) {
		
		Composite composite = new Composite(arg0, SWT.NONE);
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));

		Composite composite_1 = new Composite(composite, SWT.NONE);
		composite_1.setLayout(new FillLayout(SWT.HORIZONTAL));

		treeViewer = new TreeViewer(composite_1, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
		
		treeViewer.setContentProvider(new TreeContentProvider());
		treeViewer.setLabelProvider(new LabelProvider(){
			@Override
			public Image getImage(Object element) {
				if(element instanceof ICategory) {
					return Activator.getDefault().getImageRegistry().get("aws-box");
				}
				else if(element instanceof IIdentity) {
					IIdentity identity = (IIdentity)element;
					
					if (identity.getParent() == null) {
						return Activator.getDefault().getImageRegistry().get("account");
					}
					else {
						return Activator.getDefault().getImageRegistry().get("user");
					}
				}
				else {
					return Activator.getDefault().getImageRegistry().get("user");
				}
			}

			@Override
			public String getText(Object element) {
				if(element instanceof IIdentityManagement) {
					return ((IIdentityManagement)element).toString();
				}
				else if(element instanceof ICategory) {
					return ((ICategory)element).getName() + " (" + ((ICategory)element).getId() + ")";
				}
				else if(element instanceof IIdentity) {
					return ((IIdentity)element).getName() + " (" + ((IIdentity)element).getId() + ")";
				}
				return "";	
			}
		});

		this.getSite().setSelectionProvider(treeViewer);

		try {
			update();
		}
		catch (Throwable e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
		}
	}

	private IIdentityManagement getIdentityManagement() {
		if (im == null) {
			try {
				im = Activator.getDefault().getCloudManager().getIdentityManagement();

				// ユーザー情報の変更を追跡。
				// ユーザーの階層は、一階層で決め打ち。
				for (ICategory cat: im.getCategories()) {
					cat.addPropertyObserver2(ICategory.p2.identities, identity4Category);
					
					for (IIdentity parent: cat.getIdentities()) {
						parent.addPropertyObserver2(IIdentity.p2.name, nameObserver);
						parent.addPropertyObserver2(IIdentity.p2.identities, identity4Identity);

						for (IIdentity child: parent.getIdentities()) {
							child.addPropertyObserver2(IIdentity.p2.name, nameObserver);
						}
					}
				}
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(UsersView.class);
				logger.warn("fail to gey accounts", e);
			}
		}
		
		return im;
	}
	
	@Override
	public void setFocus() {
		treeViewer.getTree().setFocus();
	}

	public void update() {
		if (im == null) {
			im = getIdentityManagement();
			if (im != null) {
				treeViewer.setInput(im);
			}
		}
		else {
			im.update();
		}
	}

	@Override
	public void dispose() {
		// ログオフ時の動作としてモデルのリリースをこのビューで行う。
		Activator.getDefault().releaseCloudManager();

		super.dispose();
	}
}