/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

import com.clustercontrol.cloud.aws.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.commons.util.MessageManager;


/**
 */
public class UserDetailView extends ViewPart implements ISelectionListener {
	public static final String Id = "com.clustercontrol.cloud.ui.views.UserDetailView";

	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");

	private String headerTitle  = bundle_view_label.getString("view.user_detail.header_title");
	private String headerTitle2  = bundle_view_label.getString("view.user_detail.header_title2");
	private String footerTitle  = bundle_view_label.getString("view.user_detail.footer_title");
	
	private interface Observer {
		public void setup();
		public void clear();
		public List<IIdentity> getIdentityList();
	}
	
	private class CategoryObserver implements Observer {
		private AllPropertyObserver valueObserver = new AllPropertyObserver() {
			@Override
			public void elementAdded(ElementAddedEvent event) {
			}
			@Override
			public void elementRemoved(ElementRemovedEvent event) {
			}
			@Override
			public void propertyChanged(ValueChangedEvent event) {
				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
		};

		private CollectionObserver2<IIdentity> identity4Category = new CollectionObserver2<IIdentity>() {
			@Override
			public void elementAdded(ElementAddedEvent<IIdentity> event) {
				IIdentity element = event.getAddedElement();
				
				element.addPropertyObserver2(IElement.allProperty, valueObserver);
				element.addPropertyObserver2(IIdentity.p2.identities, identity4Identity);

				list.add(element);
				
				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
			@Override
			public void elementRemoved(ElementRemovedEvent<IIdentity> event) {
				IIdentity element = event.getRemovedElement();
				
				list.remove(element);

				// ユーザーの階層は、1 階層しかないことを前提の処理。
				for (IIdentity child: element.getIdentities()) {
					child.removePropertyObserver2(IElement.allProperty, valueObserver);
					child.removePropertyObserver2(IIdentity.p2.identities, identity4Identity);
				}
				
				element.removePropertyObserver2(IElement.allProperty, valueObserver);
				element.removePropertyObserver2(IIdentity.p2.identities, identity4Identity);

				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
		};
		
		private CollectionObserver2<IIdentity> identity4Identity = new CollectionObserver2<IIdentity>() {
			@Override
			public void elementAdded(ElementAddedEvent<IIdentity> event) {
				IIdentity element = event.getAddedElement();
				
				element.addPropertyObserver2(IElement.allProperty, valueObserver);

				list.add(element);

				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
			@Override
			public void elementRemoved(ElementRemovedEvent<IIdentity> event) {
				IElement element = (IElement)event.getRemovedElement();
				
				list.remove(element);

				element.removePropertyObserver2(IElement.allProperty, valueObserver);

				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
		};

		private ICategory selected;
		private Runnable refresher;
		private List<IIdentity> list = new ArrayList<IIdentity>();
		
		public CategoryObserver(ICategory selected, Runnable refresher) {
			this.selected = selected;
			this.refresher = refresher;
		}
		@Override
		public void setup() {
			selected.addPropertyObserver2(ICategory.p2.identities, identity4Category);
			
			for (IIdentity parent: selected.getIdentities()) {
				parent.addPropertyObserver2(IElement.allProperty, valueObserver);
				parent.addPropertyObserver2(IIdentity.p2.identities, identity4Identity);
				
				list.add(parent);
				for (IIdentity child: parent.getIdentities()) {
					child.addPropertyObserver2(IElement.allProperty, valueObserver);

					list.add(child);
				}
			}
			
			UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
		}
		@Override
		public void clear() {
			for (IIdentity identity: list) {
				identity.addPropertyObserver2(IElement.allProperty, valueObserver);
				identity.addPropertyObserver2(IIdentity.p2.identities, identity4Identity);
			}
			list.clear();
			selected.removePropertyObserver2(ICategory.p2.identities, identity4Category);

			UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
		}
		@Override
		public List<IIdentity> getIdentityList() {
			return list;
		}
	}
	
	private class ParentIdentityObserver implements Observer {
		private AllPropertyObserver valueObserver = new AllPropertyObserver() {
			@Override
			public void elementAdded(ElementAddedEvent event) {
			}
			@Override
			public void elementRemoved(ElementRemovedEvent event) {
			}
			@Override
			public void propertyChanged(ValueChangedEvent event) {
				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
		};
		
		private CollectionObserver2<IIdentity> identity4Identity = new CollectionObserver2<IIdentity>() {
			@Override
			public void elementAdded(ElementAddedEvent<IIdentity> event) {
				IIdentity element = event.getAddedElement();
				
				element.addPropertyObserver2(IElement.allProperty, valueObserver);

				list.add(element);

				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
			@Override
			public void elementRemoved(ElementRemovedEvent<IIdentity> event) {
				IElement element = (IElement)event.getRemovedElement();
				
				list.remove(element);

				element.removePropertyObserver2(IElement.allProperty, valueObserver);

				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
		};

		private IIdentity selected;
		private Runnable refresher;
		private List<IIdentity> list = new ArrayList<IIdentity>();
		
		public ParentIdentityObserver(IIdentity selected, Runnable refresher) {
			this.selected = selected;
			this.refresher = refresher;
		}
		@Override
		public void setup() {
			selected.addPropertyObserver2(IIdentity.p2.identities, identity4Identity);
			selected.addPropertyObserver2(IElement.allProperty, valueObserver);
			list.add(selected);
			for (IIdentity child: selected.getIdentities()) {
				child.addPropertyObserver2(IElement.allProperty, valueObserver);
				list.add(child);
			}

			UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
		}
		@Override
		public void clear() {
			for (IIdentity identity: list) {
				identity.removePropertyObserver2(IElement.allProperty, valueObserver);
				identity.removePropertyObserver2(IIdentity.p2.identities, identity4Identity);
			}
			list.clear();

			UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
		}
		@Override
		public List<IIdentity> getIdentityList() {
			return list;
		}
	}

	private class SingleIdentityObserver implements Observer {
		private AllPropertyObserver valueObserver = new AllPropertyObserver() {
			@Override
			public void elementAdded(ElementAddedEvent event) {
			}
			@Override
			public void elementRemoved(ElementRemovedEvent event) {
			}
			@Override
			public void propertyChanged(ValueChangedEvent event) {
				UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
			}
		};
		
		private IIdentity selected;
		private Runnable refresher;
		private List<IIdentity> list = new ArrayList<IIdentity>();
		
		public SingleIdentityObserver(IIdentity selected, Runnable refresher) {
			this.selected = selected;
			this.refresher = refresher;
		}
		@Override
		public void setup() {
			selected.addPropertyObserver2(IElement.allProperty, valueObserver);
			list.add(selected);

			UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
		}
		@Override
		public void clear() {
			list.clear();
			selected.removePropertyObserver2(IElement.allProperty, valueObserver);

			UserDetailView.this.getSite().getShell().getDisplay().asyncExec(refresher);
		}
		@Override
		public List<IIdentity> getIdentityList() {
			return list;
		}
	}
	
	private Runnable refresher = new Runnable() {
		@Override
		public void run() {
			// 非同期でコールバックが来るので更新。
			tableViewer.refresh(true);
			
			if (observer == null) {
				lblFooder.setText(footerTitle + 0);
			}
			else {
				lblFooder.setText(footerTitle + observer.getIdentityList().size());
			}
			
			// アクションの状態を更新。
			ISelection selection = tableViewer.getSelection();
			UserDetailView.this.getSite().getSelectionProvider().setSelection(selection);
		}
	};

	private Table table;
	private TableViewer tableViewer;
	private Label lblUser;
	private Label lblFooder;
	private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
	
	private Observer observer = null;
	
	public UserDetailView() {
	}

	@Override
	public void createPartControl(Composite arg0) {
		
		Composite composite = new Composite(arg0, SWT.NONE);
		
		lblUser = new Label(composite, SWT.NONE);
		lblUser.setSize(lblUser.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblUser.setLayoutData(gridData);

		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn, new ColumnPixelData(100, true, true));
		tblclmnNewColumn.setText(bundle_view_label.getString("view.user_detail.column.cloud_id"));
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getCategory().getId();
			}
		});
		
		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_1, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_1.setText(bundle_view_label.getString("view.user_detail.column.cloud_user_id"));
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getId();
			}
		});

		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_2, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_2.setText(bundle_view_label.getString("view.user_detail.column.cloud_user_name"));
		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getName();
			}
		});

		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_3, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_3.setText(bundle_view_label.getString("view.user_detail.column.description"));
		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getDescription();
			}
		});

		TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_4, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_4.setText(bundle_view_label.getString("view.user_detail.column.assign_user_id"));
		tableViewerColumn_4.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getHinemosUserId();
			}
		});

		TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_5, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_5.setText(bundle_view_label.getString("view.user_detail.column.reg_date"));
		tableViewerColumn_5.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getRegDate() != null ? format.format(((IIdentity)element).getRegDate()): null;
			}
		});

		TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_6, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_6.setText(bundle_view_label.getString("view.user_detail.column.update_date"));
		tableViewerColumn_6.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getUpdateDate() != null ? format.format(((IIdentity)element).getUpdateDate()): null;
			}
		});

		TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_7, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_7.setText(bundle_view_label.getString("view.user_detail.column.reg_user"));
		tableViewerColumn_7.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getRegUser();
			}
		});

		TableViewerColumn tableViewerColumn_8 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_8 = tableViewerColumn_8.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_8, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_8.setText(bundle_view_label.getString("view.user_detail.column.update_user"));
		tableViewerColumn_8.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IIdentity)element).getUpdateUser();
			}
		});

		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		lblFooder = new Label(composite, SWT.NONE);
		lblFooder.setAlignment(SWT.RIGHT);
		lblFooder.setSize(lblFooder.getSize().x, 80);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblFooder.setLayoutData(gridData);

		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}
			@Override
			public void dispose() {}
			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
		});

		getSite().getPage().addSelectionListener(this);
		getSite().setSelectionProvider(tableViewer);
	}

	@Override
	public void setFocus() {
		tableViewer.getTable().setFocus();
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (part instanceof UsersView && selection instanceof IStructuredSelection) {
			if (observer != null) {
				observer.clear();
				observer = null;
			}

			IStructuredSelection sselection = (IStructuredSelection)selection;
			if (!sselection.isEmpty()) {
				Object selected = sselection.getFirstElement();
				if (selected instanceof ICategory) {
					ICategory category = (ICategory)selected;
					lblUser.setText(headerTitle + category.getId());
					observer = new CategoryObserver((ICategory)selected, refresher);
				}
				else if (selected instanceof IIdentity) {
					IIdentity id = (IIdentity)selected; 
					lblUser.setText(headerTitle2 + id.getId());
					if (id.getParent() == null) {
						observer = new ParentIdentityObserver(id, refresher);
					}
					else {
						observer = new SingleIdentityObserver(id, refresher);
					}
				}
				tableViewer.setInput(observer.getIdentityList());
				observer.setup();
			}
		}
	}
}
