/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;


/**
 */
public class TemplatesView extends ViewPart {
	public static final String Id = "com.clustercontrol.cloud.ui.views.TemplatesView";
	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
	
	private Table table;
	private TableViewer tableViewer;
	private Label lblHeader;
	private Label lblFooter;
	private ITemplateManagement templateManagement;
	private List<ITemplate> templates; 
	private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
	private String footerTitle = bundle_view_label.getString("view.template.footer_title");
	
	private CollectionObserver2<ITemplate> elementObserver = new CollectionObserver2<ITemplate>() {
		@Override
		public void elementAdded(ElementAddedEvent<ITemplate> event) {
			event.getAddedElement().addPropertyObserver2(IElement.allProperty, propertyObserver);

			templates.add(event.getAddedElement());
			tableViewer.setInput(templates);

			lblFooter.setText(footerTitle + templates.size());

			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<ITemplate> event) {
			event.getRemovedElement().removePropertyObserver2(IElement.allProperty, propertyObserver);

			templates.remove(event.getRemovedElement());
			tableViewer.setInput(templates);
			
			lblFooter.setText(footerTitle + templates.size());

			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	private AllPropertyObserver propertyObserver = new AllPropertyObserver() {
		@Override
		public void propertyChanged(ValueChangedEvent event) {
			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementRemoved(ElementRemovedEvent event) {
			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementAdded(ElementAddedEvent event) {
			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	public TemplatesView() {
	}
	
 	@Override
	public void createPartControl(Composite arg0) {
		Composite composite = new Composite(arg0, SWT.NONE);

		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		Map<String, ColumnLabelProvider> tableColumnMap = new LinkedHashMap<String, ColumnLabelProvider>();
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.template_id"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getTemplateId();
					}
				}
		);
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.template_name"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getTemplateName();
					}
				}
		);
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.image_id"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getImageId();
					}
				}
		);
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.launch_job_id"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getLaunchJobId();
					}
				}
		);
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.region"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getRegion();
					}
				}
		);
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.reg_date"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getRegDate() != null ? format.format(((ITemplate)element).getRegDate().getTime()): null;
					}
				}
		);
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.update_date"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getUpdateDate() != null ? format.format(((ITemplate)element).getUpdateDate().getTime()): null;
					}
				}
		);
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.reg_user"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getRegUser();
					}
				}
		);
		tableColumnMap.put(
				bundle_view_label.getString("view.template.column.update_user"),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((ITemplate)element).getUpdateUser();
					}
				}
		);

		TableViewerColumn[] tableViewerColumns = new TableViewerColumn[tableColumnMap.size()];
		TableColumn[] tableColumns = new TableColumn[tableColumnMap.size()];
		int i = 0;
		for(final Map.Entry<String, ColumnLabelProvider> entry: tableColumnMap.entrySet()){
			tableViewerColumns[i] = new TableViewerColumn(tableViewer, SWT.NONE);
			tableColumns[i] = tableViewerColumns[i].getColumn();
			tcl_composite_1.setColumnData(tableColumns[i], new ColumnPixelData(100, true, true));
			tableColumns[i].setText(entry.getKey());
			tableViewerColumns[i].setLabelProvider(entry.getValue());
			tableColumns[i].addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, entry.getValue()));
				}
			});
		}

		this.getSite().setSelectionProvider(tableViewer);
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		lblFooter = new Label(composite, SWT.NONE);
		lblFooter.setAlignment(SWT.RIGHT);
		lblFooter.setSize(lblFooter.getSize().x, 80);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblFooter.setLayoutData(gridData);
		
		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		try {
			update();
		}
		catch (Throwable e) {
			lblFooter.setText(footerTitle + 0);
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
		}
	}

	private List<ITemplate> getTemplates() {
		if (templates == null) {
			try {
				templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
				templateManagement.addPropertyObserver2(ITemplateManagement.p2.templates, elementObserver);
				for (ITemplate template: templateManagement.getTemplates()) {
					template.addPropertyObserver2(IElement.allProperty, propertyObserver);
				}
				
				templates = new ArrayList<ITemplate>();
				templates.addAll(Arrays.asList(templateManagement.getTemplates()));
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(TemplatesView.class);
				logger.warn("fail to get templates", e);

				templates = new ArrayList<ITemplate>();
			}
		}
		
		return templates;
	}
 	
	public void update() {
		if (templates != null) {
			for (ITemplate template: templates) {
				template.removePropertyObserver2(IElement.allProperty, propertyObserver);
			}
			templates = null;
		}

		if (templateManagement != null) {
			templateManagement.removePropertyObserver2(ITemplateManagement.p2.templates, elementObserver);
			templateManagement.update();
		}

		List<ITemplate> billingAlarms = getTemplates();
		tableViewer.setInput(billingAlarms);
		lblFooter.setText(footerTitle + billingAlarms.size());
	}

	@Override
	public void setFocus() {
		tableViewer.getControl().setFocus();
	}
}
