///*
//Copyright (C) 2013 NTT DATA Corporation
//
//This program is free software; you can redistribute it and/or
//Modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation, version 2.
//
//This program is distributed in the hope that it will be
//useful, but WITHOUT ANY WARRANTY; without even the implied
//warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//PURPOSE.  See the GNU General Public License for more details.
// */
//package com.clustercontrol.cloud.ui.views;
//
//import java.util.Arrays;
//import java.util.List;
//
//import org.eclipse.jface.layout.TableColumnLayout;
//import org.eclipse.jface.viewers.ColumnLabelProvider;
//import org.eclipse.jface.viewers.ColumnPixelData;
//import org.eclipse.jface.viewers.IStructuredContentProvider;
//import org.eclipse.jface.viewers.StructuredViewer;
//import org.eclipse.jface.viewers.TableViewer;
//import org.eclipse.jface.viewers.TableViewerColumn;
//import org.eclipse.jface.viewers.Viewer;
//import org.eclipse.swt.SWT;
//import org.eclipse.swt.layout.GridData;
//import org.eclipse.swt.layout.GridLayout;
//import org.eclipse.swt.widgets.Composite;
//import org.eclipse.swt.widgets.Label;
//import org.eclipse.swt.widgets.Table;
//import org.eclipse.swt.widgets.TableColumn;
//import org.eclipse.ui.ISelectionListener;
//
//import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
//import com.clustercontrol.cloud.aws.presenter.INetworkSecurityRoot;
//import com.clustercontrol.cloud.aws.presenter.IRegion;
//import com.clustercontrol.cloud.aws.presenter.ISecurityGroup;
//import com.clustercontrol.cloud.aws.presenter.NetworkSecurityRoot;
//import com.clustercontrol.cloud.aws.presenter.PropertyId2;
//import com.clustercontrol.cloud.commons.util.MessageManager;
//import com.clustercontrol.ws.cloud.CloudEndpoint;
//import com.clustercontrol.ws.cloud.CloudSecurityGroup;
//
//
///**
// */
//public class SecurityGroupsView extends FilterlingViewPartByScopeTree<INetworkSecurityRoot, ISecurityGroup, CloudSecurityGroup> implements ISelectionListener {
//	public static final String Id = "com.clustercontrol.cloud.ui.views.SecurityGroupsView";
//
//	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
//	
//	private Label lblHeader;
//	private FooterComposite footerComposite;
//	private Table table;
//	private TableViewer tableViewer;
//
//	public SecurityGroupsView() {
//	}
//
//	@Override
//	public void createPartControl(Composite arg0) {
//		
//		Composite composite = new Composite(arg0, SWT.NONE);
//		
//		lblHeader = new Label(composite, SWT.NONE);
//		lblHeader.setSize(lblHeader.getSize().x, 80);
//		GridData gridData = new GridData();
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.verticalAlignment = GridData.FILL;
//		lblHeader.setLayoutData(gridData);
//		
//		Composite composite_1 = new Composite(composite, SWT.NONE);
//		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
//		composite_1.setLayout(tcl_composite_1);
//
//		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
//		table = tableViewer.getTable();
//		table.setHeaderVisible(true);
//		table.setLinesVisible(true);
//
//		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
//		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
//		tcl_composite_1.setColumnData(tblclmnNewColumn, new ColumnPixelData(100, true, true));
//		tblclmnNewColumn.setText(bundle_view_label.getString("view.security_group.column.security_group_id"));
//		tableViewerColumn.setLabelProvider(new ColumnLabelProvider(){
//			@Override
//			public String getText(Object element) {
//				return ((ISecurityGroup)element).getSecurityGroupId();
//			}
//		});
//		
//		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
//		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
//		tcl_composite_1.setColumnData(tblclmnNewColumn_1, new ColumnPixelData(100, true, true));
//		tblclmnNewColumn_1.setText(bundle_view_label.getString("view.security_group.column.security_group_name"));
//		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider(){
//			@Override
//			public String getText(Object element) {
//				return ((ISecurityGroup)element).getSecurityGroupName();
//			}
//		});
//
//		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
//		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
//		tcl_composite_1.setColumnData(tblclmnNewColumn_2, new ColumnPixelData(100, true, true));
//		tblclmnNewColumn_2.setText(bundle_view_label.getString("view.security_group.column.description"));
//		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider(){
//			@Override
//			public String getText(Object element) {
//				return ((ISecurityGroup)element).getDescription();
//			}
//		});
//
//		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
//		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
//		tcl_composite_1.setColumnData(tblclmnNewColumn_3, new ColumnPixelData(100, true, true));
//		tblclmnNewColumn_3.setText(bundle_view_label.getString("view.security_group.column.vpc_id"));
//		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider(){
//			@Override
//			public String getText(Object element) {
//				return ((ISecurityGroup)element).getVpcId();
//			}
//		});
//		
//		this.getSite().setSelectionProvider(tableViewer);
//
//		GridLayout gl_composite = new GridLayout(1, true);
//		gl_composite.horizontalSpacing = 0;
//		gl_composite.marginHeight = 0;
//		gl_composite.marginWidth = 0;
//		gl_composite.verticalSpacing = 0;
//		composite.setLayout(gl_composite);
//
//		gridData = new GridData();
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.verticalAlignment = GridData.FILL;
//		gridData.grabExcessHorizontalSpace = true;
//		gridData.grabExcessVerticalSpace = true;
//		composite_1.setLayoutData(gridData);
//
//		tableViewer.setContentProvider(new IStructuredContentProvider() {
//			@Override
//			public Object[] getElements(Object inputElement) {
//				return ((List<?>) inputElement).toArray();
//			}
//
//			@Override
//			public void dispose() {
//
//			}
//
//			@Override
//			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
//			}
//		});
//
//		footerComposite = new FooterComposite(composite, SWT.NONE);
//		gridData = new GridData();
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.verticalAlignment = GridData.FILL;
//		footerComposite.setSize(lblHeader.getSize().x, 80);
//		footerComposite.setLayoutData(gridData);
//
//		getSite().getPage().addSelectionListener(this);
//		getSite().setSelectionProvider(tableViewer);
//		
//		update();
//	}
//
//	@Override
//	protected boolean isMatchRegion(IRegion region, ISecurityGroup element) {
//		return element.getNetworkSecurityRoot().getRegion() == region;
//	}
//	@Override
//	protected boolean isMatchAvailabilityZone(String zoneName, ISecurityGroup element) {
//		return true;
//	}
//	@Override
//	protected boolean isMatchFacilityId(String facilityId, ISecurityGroup element) {
//		return true;
//	}
//	@Override
//	protected Label getHeaderLabel() {
//		return lblHeader;
//	}
//	@Override
//	protected Label getLeftFooter() {
//		return footerComposite.getLeftControl();
//	}
//	@Override
//	protected Label getRightFooter() {
//		return footerComposite.getRightControl();
//	}
//	@Override
//	protected INetworkSecurityRoot getRootElement(IRegion region) {
//		return region.getNetworkSecurityRoot();
//	}
//	@Override
//	protected List<ISecurityGroup> getElements(INetworkSecurityRoot root) {
//		return Arrays.asList(root.getSecurityGroups());
//	}
//	@Override
//	protected PropertyId2<CollectionObserver2<ISecurityGroup>> getPropertyId() {
//		return INetworkSecurityRoot.p2.securityGroups;
//	}
//	@Override
//	protected List<CloudSecurityGroup> getManagerElements(CloudEndpoint endpoint, IRegion target) {
//		try {
//			return endpoint.getSecurityGroupsByRegion(target.getRegionName());
//		}
//		catch (Exception e) {
//			throw new IllegalStateException(e);
//		}
//	}
//
//	@Override
//	protected void setManagerElements(INetworkSecurityRoot rootElement, List<CloudSecurityGroup> managerElements) {
//		((NetworkSecurityRoot)rootElement).internalUpdate(managerElements);
//	}
//
//	@Override
//	protected boolean isInitialized(INetworkSecurityRoot rootElement) {
//		return ((NetworkSecurityRoot)rootElement).isInitialized();
//	}
//
//	@Override
//	protected StructuredViewer getViewer() {
//		return tableViewer;
//	}
//}