/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;

import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.GroupIdentifier;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstanceRoot;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.InstanceRoot;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.aws.presenter.IInstance.Tag;
import com.clustercontrol.cloud.commons.util.CloudClientConstants;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.actions.ClipDnsAction;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstance;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;

/**
 */
public class InstancesView2 extends FilterlingViewPartByScopeTree<IInstanceRoot, IInstance, CloudInstance> implements ISelectionListener {
	public static final String Id = "com.clustercontrol.cloud.ui.views.InstancesView";

	private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
	private MessageManager bundle_region = MessageManager.getInstance("region");
	private MessageManager bundle_instance_state = MessageManager.getInstance("instance_state");
	//	private MessageManager bundle_instance_type = MessageManager.getInstance("instance_type");
	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");

	private Label lblHeader;
	private FooterComposite footerComposite;
	private Table table;
	private TableViewer tableViewer;

	private ISelectionProvider provider = new ISelectionProvider() {
		private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

		ISelection theSelection = StructuredSelection.EMPTY;

		public void addSelectionChangedListener(ISelectionChangedListener listener) {
			listeners.add(listener);
		}

		public ISelection getSelection() {
			return theSelection;
		}

		public void removeSelectionChangedListener(ISelectionChangedListener listener) {
			listeners.remove(listener);
		}

		public void setSelection(ISelection selection) {
			theSelection = selection;
			SelectionChangedEvent e = new SelectionChangedEvent(this, selection);
			for (ISelectionChangedListener l: listeners) {
				l.selectionChanged(e);
			}
		}
	};

	public InstancesView2() {
	}

	@Override
	public void createPartControl(Composite arg0) {
		Composite composite = new Composite(arg0, SWT.NONE);
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);

		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);

		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn, new ColumnPixelData(100, true, true));
		tblclmnNewColumn.setText(bundle_view_label.getString("view.instance.column.facility_id"));
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getFacilityId();
			}
		});

		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_2, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_2.setText(bundle_view_label.getString("view.instance.column.facility_name"));
		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getFacilityName();
			}
		});

		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_3, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_3.setText(bundle_view_label.getString("view.instance.column.instance_id"));
		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getInstanceId();
			}
		});

		TableViewerColumn tableViewerColumn_15 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_15 = tableViewerColumn_15.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_15, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_15.setText(bundle_view_label.getString("view.instance.column.instance_name"));
		tableViewerColumn_15.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getInstanceName();
			}
		});

		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_1, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_1.setText(bundle_view_label.getString("view.instance.column.platform"));
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getPlatform();
			}
		});

		TableViewerColumn tableViewerColumn_16 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_16 = tableViewerColumn_16.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_16, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_16.setText(bundle_view_label.getString("view.instance.column.cloud_id"));
		tableViewerColumn_16.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getCloudId();
			}
		});

		TableViewerColumn tableViewerColumn_22 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_22 = tableViewerColumn_22.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_22, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_22.setText(bundle_view_label.getString("view.instance.column.cloud_user_id"));
		tableViewerColumn_22.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getCloudUserId();
			}
		});

		TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_4, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_4.setText(bundle_view_label.getString("view.instance.column.region"));
		tableViewerColumn_4.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				String regionName = bundle_region.getString(((IInstance)element).getRegion().getRegionName());
				return regionName != null ? regionName: ((IInstance)element).getRegion().getRegionName();
			}
		});

		TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_5, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_5.setText(bundle_view_label.getString("view.instance.column.availability_zone"));
		tableViewerColumn_5.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getAvailabilityZone();
			}
		});

		TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_6, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_6.setText(bundle_view_label.getString("view.instance.column.security_group"));
		tableViewerColumn_6.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				IInstance instance = (IInstance)element;
				String securityGroups = null;
				if (!instance.getSecurityGroups().isEmpty()) {
					StringBuilder sb = new StringBuilder();
					for (int i = 0; i < instance.getSecurityGroups().size(); ++i) {
						GroupIdentifier gi = instance.getSecurityGroups().get(i);
						sb.append(gi.getGroupName());
						if (i != instance.getSecurityGroups().size() - 1) {
							sb.append(CloudClientConstants.VIEW_CONSTANTS_INSTANCE_SECURITY_GROUP_DELIMITER);
						}
					}
					securityGroups = sb.toString();
				}
				else {
					securityGroups = CloudClientConstants.VIEW_CONSTANTS_INSTANCE_DEFAULT_SECURITY_GROUP;
				}

				return  securityGroups;
			}
		});

		TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_7, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_7.setText(bundle_view_label.getString("view.instance.column.public_dns_name"));
		tableViewerColumn_7.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getPublicDnsName();
			}
		});

		TableViewerColumn tableViewerColumn_8 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_8 = tableViewerColumn_8.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_8, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_8.setText(bundle_view_label.getString("view.instance.column.image_id"));
		tableViewerColumn_8.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getImageId();
			}
		});

		TableViewerColumn tableViewerColumn_9 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_9 = tableViewerColumn_9.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_9, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_9.setText(bundle_view_label.getString("view.instance.column.root_device_type"));
		tableViewerColumn_9.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getRootDeviceType();
			}
		});

		TableViewerColumn tableViewerColumn_10 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_10 = tableViewerColumn_10.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_10, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_10.setText(bundle_view_label.getString("view.instance.column.state"));
		tableViewerColumn_10.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				if (((IInstance)element).getState() != null) {
					String stateName = bundle_instance_state.getString(((IInstance)element).getState().label());
					return stateName != null ? stateName+" ("+((IInstance)element).getState().label()+")": ((IInstance)element).getState().label();
				}
				return null;
			}
		});

		TableViewerColumn tableViewerColumn_17 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_17 = tableViewerColumn_17.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_17, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_17.setText(bundle_view_label.getString("view.instance.column.regist_state"));
		tableViewerColumn_17.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getRegistState().name();
			}
		});

		TableViewerColumn tableViewerColumn_11 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_11 = tableViewerColumn_11.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_11, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_11.setText(bundle_view_label.getString("view.instance.column.type"));
		tableViewerColumn_11.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getType();
			}
		});

		TableViewerColumn tableViewerColumn_12 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_12 = tableViewerColumn_12.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_12, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_12.setText(bundle_view_label.getString("view.instance.column.key_pair"));
		tableViewerColumn_12.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getKeyPair();
			}
		});

		TableViewerColumn tableViewerColumn_13 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_13 = tableViewerColumn_13.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_13, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_13.setText(bundle_view_label.getString("view.instance.column.launch_time"));
		tableViewerColumn_13.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getLaunchTime() != null ? ((IInstance)element).getLaunchTime().toString(): null;
			}
		});

		TableViewerColumn tableViewerColumn_14 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_14 = tableViewerColumn_14.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_14, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_14.setText(bundle_view_label.getString("view.instance.column.tags"));
		tableViewerColumn_14.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				IInstance instance = (IInstance)element;
				String tags = null;
				if (!instance.getTags().isEmpty()) {
					StringBuilder sb = new StringBuilder();
					for (int i = 0; i < instance.getTags().size(); ++i) {
						Tag tag = instance.getTags().get(i);
						sb.append(tag.getName()).append(CloudClientConstants.VIEW_CONSTANTS_INSTANCE_TAGS_BRIDGE).append(tag.getValue());
						if (i != instance.getTags().size() - 1) {
							sb.append(CloudClientConstants.VIEW_CONSTANTS_INSTANCE_TAGS_DELIMITER);
						}
					}
					tags = sb.toString();
				}
				else {
					tags = CloudClientConstants.VIEW_CONSTANTS_INSTANCE_DEFAULT_TAGS;
				}

				return tags;
			}
		});
		TableViewerColumn tableViewerColumn_23 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_23 = tableViewerColumn_23.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_23, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_23.setText(bundle_view_label.getString("view.instance.column.template_id"));
		tableViewerColumn_23.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getTemplateId();
			}
		});

		TableViewerColumn tableViewerColumn_18 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_18 = tableViewerColumn_18.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_18, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_18.setText(bundle_view_label.getString("view.instance.column.reg_date"));
		tableViewerColumn_18.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getRegDate() != null ? ((IInstance)element).getRegDate().toString(): null;
			}
		});

		TableViewerColumn tableViewerColumn_19 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_19 = tableViewerColumn_19.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_19, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_19.setText(bundle_view_label.getString("view.instance.column.update_date"));
		tableViewerColumn_19.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getUpdateDate() != null ? ((IInstance)element).getUpdateDate().toString(): null;
			}
		});

		TableViewerColumn tableViewerColumn_20 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_20 = tableViewerColumn_20.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_20, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_20.setText(bundle_view_label.getString("view.instance.column.reg_user"));
		tableViewerColumn_20.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getRegUser() != null ? ((IInstance)element).getRegUser(): null;
			}
		});

		TableViewerColumn tableViewerColumn_21 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_21 = tableViewerColumn_21.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_21, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_21.setText(bundle_view_label.getString("view.instance.column.update_user"));
		tableViewerColumn_21.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstance)element).getUpdateUser() != null ? ((IInstance)element).getUpdateUser(): null;
			}
		});

		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		footerComposite = new FooterComposite(composite, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		footerComposite.setSize(lblHeader.getSize().x, 80);
		footerComposite.setLayoutData(gridData);

		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>)inputElement).toArray();
			}
			@Override
			public void dispose() {
			}
			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		getSite().getPage().addSelectionListener(this);

		tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				List<Object> selection = new ArrayList<Object>();
//				if (getCurrentState() != null) {
//					selection.add(getCurrentState());
//				}
				
				if (event.getSelection() instanceof IStructuredSelection) {
					Iterator<?> iter = ((IStructuredSelection)event.getSelection()).iterator();
					while (iter.hasNext()) {
						selection.add(iter.next());
					}
				}
				provider.setSelection(new StructuredSelection(selection.toArray()));
			}
		});

		getSite().setSelectionProvider(provider);

		update();

		//ポップアップメニュー作成
		createContextMenu();
	}
	@Override
	protected void updateStatus() {
//		StructuredSelection selection = null;
//		if (getCurrentState() != null) {
//			selection = new StructuredSelection(new Object[]{getCurrentState()});
//		}
//		else {
//			selection = new StructuredSelection();
//		}
//		provider.setSelection(selection);
		
		super.updateStatus();
	}
	
	protected void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(this.table);
		this.table.setMenu(menu);
	}

	protected void fillContextMenu(IMenuManager manager) {
		//ポップアップメニューにアクションを追加
		IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
		ActionContributionItem addAction = (ActionContributionItem) toolbar.find(ClipDnsAction.ID);
		manager.add(addAction.getAction());
	}
	@Override
	protected IInstanceRoot getRootElement(IRegion region) {
		return region.getInstanceRoot();
	}
	@Override
	protected List<IInstance> getElements(IInstanceRoot root) {
		return Arrays.asList(root.getInstances());
	}
	@Override
	protected PropertyId2<CollectionObserver2<IInstance>> getPropertyId() {
		return IInstanceRoot.p2.instances;
	}
	@Override
	protected boolean isMatchRegion(IRegion region, IInstance element) {
		return element.getRegion() == region;
	}
	@Override
	protected boolean isMatchAvailabilityZone(String zoneName, IInstance element) {
		return zoneName.equals(element.getAvailabilityZone());
	}
	@Override
	protected boolean isMatchFacilityId(String facilityId, IInstance element) {
		return facilityId.equals(element.getFacilityId());
	}
	@Override
	protected Label getHeaderLabel() {
		return lblHeader;
	}
	@Override
	protected Label getLeftFooter() {
		return footerComposite.getLeftControl();
	}
	@Override
	protected Label getRightFooter() {
		return footerComposite.getRightControl();
	}
	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
	@Override
	protected List<CloudInstance> getManagerElements(CloudEndpoint endpoint, IRegion region) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception, ValidationFault_Exception {
		return endpoint.getInstancesByRegion(region.getRegionName());
	}
	@Override
	protected void setManagerElements(IInstanceRoot rootElement, List<CloudInstance> ManagerElements) {
		((InstanceRoot)rootElement).internalUpdate(ManagerElements);
	}
	@Override
	protected boolean isInitialized(IInstanceRoot rootElement) {
		return ((InstanceRoot)rootElement).isInitialized();
	}
	@Override
	protected ThreadPoolExecutor getExecutor() {
		return threadPool;
	}
}