/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;

import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstanceBackup;
import com.clustercontrol.cloud.aws.presenter.IInstanceBackupRoot;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.InstanceBackupRoot;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.commons.util.CloudClientConstants;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstanceBackup;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;


/**
 */
public class InstanceBackupView extends FilterlingViewPartByScopeTree2<IInstanceBackupRoot, IInstanceBackup, CloudInstanceBackup> implements ISelectionListener {
	public static final String Id = "com.clustercontrol.cloud.ui.views.InstanceBackupView";

	private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
	private MessageManager bundle_region = MessageManager.getInstance("region");

	private Table table;
	private TableViewer tableViewer;
	private Label lblHeader;
	private FooterComposite footerComposite;
	private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");

	public InstanceBackupView() {
	}

	@Override
	public void createPartControl(Composite arg0) {
		Composite composite = new Composite(arg0, SWT.NONE);
		
		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);

		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn, new ColumnPixelData(100, true, true));
		tblclmnNewColumn.setText(bundle_view_label.getString("view.instance_backup.column.image_id"));
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstanceBackup)element).getImageId();
			}
		});
		
		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_1, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_1.setText(bundle_view_label.getString("view.instance_backup.column.image_name"));
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IInstanceBackup)element).getImageName();
			}
		});

		TableViewerColumn tableViewerColumn_8 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_8 = tableViewerColumn_8.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_8, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_8.setText(bundle_view_label.getString("view.instance_backup.column.cloud_id"));
		tableViewerColumn_8.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IInstanceBackup)element).getCloudId();
			}
		});

		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_2, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_2.setText(bundle_view_label.getString("view.instance_backup.column.description"));
		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IInstanceBackup)element).getDescription();
			}
		});

		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_3, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_3.setText(bundle_view_label.getString("view.instance_backup.column.image_type"));
		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IInstanceBackup)element).getImageType();
			}
		});

		TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_4, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_4.setText(bundle_view_label.getString("view.instance_backup.column.facility_id"));
		tableViewerColumn_4.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IInstanceBackup)element).getFacilityId();
			}
		});

		TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_5, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_5.setText(bundle_view_label.getString("view.instance_backup.column.instance_id"));
		tableViewerColumn_5.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IInstanceBackup)element).getInstanceId();
			}
		});

		TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_6, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_6.setText(bundle_view_label.getString("view.instance_backup.column.platform"));
		tableViewerColumn_6.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				IInstanceBackup backup = (IInstanceBackup)element;
				if(backup.getExistsStatus() == IInstanceBackup.ExistStatusType.exist){
					if(backup.getPlatform() != null && !"".equals(backup.getPlatform())){
						return backup.getPlatform();
					} else {
						return CloudClientConstants.VIEW_CONSTANTS_INSTANCE_BACKUP_DEFAULT_PLATFORM;
					}
				}
				return null;
			}
		});

		TableViewerColumn tableViewerColumn_9 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_9 = tableViewerColumn_9.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_9, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_9.setText(bundle_view_label.getString("view.instance_backup.column.exist_status"));
		tableViewerColumn_9.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				switch(((IInstanceBackup)element).getExistsStatus()){
				case exist:
					return bundle_view_label.getString("view.instance_backup.exist");
				case nothing:
					return bundle_view_label.getString("view.instance_backup.nothing");
				default:
					throw new InvalidStateException();
				}
			}
		});

		TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_7, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_7.setText(bundle_view_label.getString("view.instance_backup.column.reg_date"));
		tableViewerColumn_7.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return format.format(((IInstanceBackup)element).getRegDate());
			}
		});

		TableViewerColumn tableViewerColumn_10 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_10 = tableViewerColumn_10.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_10, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_10.setText(bundle_view_label.getString("view.instance_backup.column.reg_user"));
		tableViewerColumn_10.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IInstanceBackup)element).getRegUser();
			}
		});
		
		this.getSite().setSelectionProvider(tableViewer);
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		footerComposite = new FooterComposite(composite, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		footerComposite.setSize(lblHeader.getSize().x, 80);
		footerComposite.setLayoutData(gridData);

		getSite().getPage().addSelectionListener(this);
		getSite().setSelectionProvider(tableViewer);

		update();
	}

	@Override
	protected String getHeaderByElementId(IRegion region, List<String> elementIds) {
		if (!elementIds.isEmpty()) {
			return bundle_view_label.getString("view.instance.header_title") + bundle_region.getString(region.getRegionName()) + " " + bundle_view_label.getString("view.instance.header_title3") + elementIds.get(0);
		}
		else {
			return bundle_view_label.getString("view.instance.header_title") + bundle_region.getString(region.getRegionName());
		}
	}
	@Override
	protected boolean isMatchRegion(IRegion region, IInstanceBackup element) {
		return region.getRegionName().equals(element.getRegion());
	}
	@Override
	protected boolean isMatchFacilityIds(List<String> facilityIds, IInstanceBackup element) {
		if (facilityIds.isEmpty() || facilityIds.size() > 1) {
			return false;
		}
		return element.getFacilityId().equals(facilityIds.get(0));
	}
	@Override
	protected Label getHeaderLabel() {
		return lblHeader;
	}
	@Override
	protected Label getLeftFooter() {
		return footerComposite.getLeftControl();
	}
	@Override
	protected Label getRightFooter() {
		return footerComposite.getRightControl();
	}
	@Override
	protected IInstanceBackupRoot getRootElement(IRegion region) {
		return region.getBackupManagement().getInstanceBackupRoot();
	}
	@Override
	protected List<IInstanceBackup> getElements(IInstanceBackupRoot root) {
		return Arrays.asList(root.getInstanceBackups());
	}
	@Override
	protected PropertyId2<CollectionObserver2<IInstanceBackup>> getPropertyId() {
		return IInstanceBackupRoot.p2.instanceBackups;
	}
	@Override
	protected List<CloudInstanceBackup> getManagerElements(CloudEndpoint endpoint, IRegion target) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception, ValidationFault_Exception {
		return endpoint.getInstanceBackupsByRegion(target.getRegionName());
	}
	@Override
	protected void setManagerElements(IInstanceBackupRoot rootElement, List<CloudInstanceBackup> managerElements) {
		((InstanceBackupRoot)rootElement).internalUpdate(managerElements);
	}
	@Override
	protected boolean isInitialized(IInstanceBackupRoot rootElement) {
		return ((InstanceBackupRoot)rootElement).isInitialized();
	}
	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}

	@Override
	protected String getElementId(Object selected) {
		if (selected instanceof IInstance) {
			return ((IInstance)selected).getFacilityId();
		}
		return null;
	}

	@Override
	protected String getSupportViewId() {
		return InstancesView2.Id;
	}

	@Override
	protected ThreadPoolExecutor getExecutor() {
		return threadPool;
	}
}
