/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.aws.presenter.AccessKey;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class RegistAccountDialog extends Dialog {
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	public static class Model {
		public String id;
		public String name;
		public AccessKey key = new AccessKey();
		public String description;
		public String hinemosUserId;
		public ICategory category;
	}
	
	public enum Mode {
		regist,
		modify;
	}
	
	public enum Type {
		account,
		user;
	}

	private Model input = new Model();
	private Model output = new Model();
	private Mode mode;
	private Type type;
	private String[] userIdList = new String[0];
	private ICategory category;

	private Text txtCloudUserId;
	private Text txtCloudUserName;
	private Text txtDescription;
	private Text textAccessKey;
	private Text textSecretKey;
	private Combo comboUserId;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public RegistAccountDialog(Shell parentShell, Mode mode, Type type) {
		super(parentShell);
		this.mode = mode;
		this.type = type;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		
		Composite composite = new Composite(area, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));
		GridData gd_composite = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_composite.heightHint = 411;
		gd_composite.widthHint = 217;
		composite.setLayoutData(gd_composite);
		
		Group group_1 = new Group(composite, SWT.NONE);
		group_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		switch (type) {
		case account:
			group_1.setText(bundle_dialog_label.getString("dialog.regist_account.group.account_info_title"));
			break;
		case user:
			group_1.setText(bundle_dialog_label.getString("dialog.regist_account.group.user_info_title"));
			break;
		}
		GridLayout gl_group_1 = new GridLayout(2, false);
		gl_group_1.horizontalSpacing = 16;
		group_1.setLayout(gl_group_1);
		
		Label lblCloudType = new Label(group_1, SWT.RIGHT);
		lblCloudType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblCloudType.setText(bundle_dialog_label.getString("dialog.regist_account.cloud_id_title"));
		
		Text textCloudType = new Text(group_1, SWT.BORDER);
		textCloudType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		textCloudType.setEditable(false);
		new Label(group_1, SWT.NONE);
		new Label(group_1, SWT.NONE);
		
		Label lblSecurityGroupName = new Label(group_1, SWT.RIGHT);
		lblSecurityGroupName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSecurityGroupName.setText(bundle_dialog_label.getString("dialog.regist_account.cloud_user_id_title"));
		
		txtCloudUserId = new Text(group_1, SWT.BORDER);
		txtCloudUserId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		new Label(group_1, SWT.NONE);
		new Label(group_1, SWT.NONE);
		
		Label lblDescription = new Label(group_1, SWT.RIGHT);
		lblDescription.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText(bundle_dialog_label.getString("dialog.regist_account.cloud_user_name_title"));
		
		txtCloudUserName = new Text(group_1, SWT.BORDER);
		txtCloudUserName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		new Label(group_1, SWT.NONE);
		new Label(group_1, SWT.NONE);
		
		Label lblUserid = new Label(group_1, SWT.RIGHT);
		lblUserid.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblUserid.setText(bundle_dialog_label.getString("dialog.regist_account.description_title"));
		
		txtDescription = new Text(group_1, SWT.BORDER);
		txtDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Group group_2 = new Group(composite, SWT.NONE);
		group_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		group_2.setText(bundle_dialog_label.getString("dialog.regist_account.group.security_property_title"));
		GridLayout gl_group_2 = new GridLayout(2, false);
		gl_group_2.horizontalSpacing = 16;
		group_2.setLayout(gl_group_2);
		
		Label lblAccessKey = new Label(group_2, SWT.RIGHT);
		lblAccessKey.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAccessKey.setText(bundle_dialog_label.getString("dialog.regist_account.access_key_title"));
		((GridData)lblAccessKey.getLayoutData()).widthHint = 106;
		
		textAccessKey = new Text(group_2, SWT.BORDER);
		textAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		new Label(group_2, SWT.NONE);
		new Label(group_2, SWT.NONE);
		
		Label lblSecretKey = new Label(group_2, SWT.RIGHT);
		lblSecretKey.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSecretKey.setSize(76, 18);
		lblSecretKey.setText(bundle_dialog_label.getString("dialog.regist_account.secret_key_title"));
		
		textSecretKey = new Text(group_2, SWT.BORDER | SWT.PASSWORD);
		textSecretKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		textSecretKey.setSize(765, 24);
		new Label(group_2, SWT.NONE);
		new Label(group_2, SWT.NONE);
		
		Label lblUserId = new Label(group_2, SWT.RIGHT);
		lblUserId.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblUserId.setSize(51, 18);
		lblUserId.setText(bundle_dialog_label.getString("dialog.regist_account.assign_user_id_title"));
		
		comboUserId = new Combo(group_2, SWT.READ_ONLY);
		GridData gd_comboUserId = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_comboUserId.widthHint = 100;
		comboUserId.setLayoutData(gd_comboUserId);
		comboUserId.setSize(832, 26);
		
		switch (mode) {
		case regist:
			{
				textCloudType.setText(category.getName());

				if (userIdList.length == 0) {
					comboUserId.setEnabled(false);
				}
				else {
					for (String p: userIdList) {
						comboUserId.add(p);
					}
					comboUserId.select(0);
				}
			}
			break;
		case modify:
			{
				txtCloudUserId.setEditable(false);

				textCloudType.setText(this.input.category.getName());
				txtCloudUserId.setText(this.input.id);
				txtCloudUserName.setText(this.input.name);
				if (this.input.description != null) {
					txtDescription.setText(this.input.description);
				}
				if (this.input.key.getAccessKey() != null) {
					textAccessKey.setText(this.input.key.getAccessKey());
				}
				if (this.input.key.getSecretKey() != null) {
					textSecretKey.setText(this.input.key.getSecretKey());
				}
				comboUserId.add(this.input.hinemosUserId, 0);
				comboUserId.select(0);
				comboUserId.setEnabled(false);
			}
			break;
		}

		ControlUtil.setRequired(new Control[]{txtCloudUserId, txtCloudUserName});

		// 項目名の幅をグループ間で一致させる。
		area.layout();
		Label[] labels = new Label[]{lblCloudType, lblSecurityGroupName, lblDescription, lblUserid, lblAccessKey, lblSecretKey, lblUserId};
		int maxWidth = 0;
		for (Label l: labels) {
			Point p = l.getSize();
			maxWidth = Math.max(maxWidth, p.x);
		}
		for (Label l: labels) {
			((GridData)l.getLayoutData()).widthHint = maxWidth;
		}
		group_1.layout(true);
		group_2.layout(true);

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, false);
		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 520);
	}

	@Override
	protected void okPressed() {
		if(
			"".equals(txtCloudUserId.getText()) || "".equals(txtCloudUserName.getText())
			){
			MessageDialog.openError(null, Messages.getString("failed"), bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}

		output.category = category;
		output.id = txtCloudUserId.getText();
		output.name = txtCloudUserName.getText();
		output.description = txtDescription.getText();
		output.key.setAccessKey(textAccessKey.getText());
		output.key.setSecretKey(textSecretKey.getText());
		output.hinemosUserId = comboUserId.getText();

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		
		switch (type) {
		case account:
			newShell.setText(bundle_dialog_name.getString("regist_account"));
			break;
		case user:
			newShell.setText(bundle_dialog_name.getString("regist_user"));
			break;
		}
	}

	public void setInput(Model input) {
		assert input != null;
		this.input = input;
	}

	public void setUserIdList(String[] userIdList) {
		this.userIdList = userIdList;
	}

	public void setCategory(ICategory category) {
		this.category = category;
	}

	public Model getOutput() {
		return output;
	}
}
