/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.aws.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.commons.util.CloudClientConstants;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;

public class EditTemplateJobArgumentDialog extends Dialog {
	
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private Table table;
	private TableViewer tableViewer;
	
	private String jobId = "";
	private String templateId = "";
	
	private TemplateJobUtil.TemplateJobnet templateJob;

	private Text txtTemplateId;
	private Text txtJobnetId;
	
	private List<TemplateJobUtil.TemplateJob> jobInfos = new ArrayList<TemplateJobUtil.TemplateJob>();
	
	private List<TemplateJobsArgument> arguments = new ArrayList<TemplateJobsArgument>();
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public EditTemplateJobArgumentDialog(Shell parentShell, String templateId, String jobId){
		super(parentShell);
		this.templateId = templateId;
		this.jobId = jobId;
		
		try {
			for(TemplateJobUtil.TemplateJobnet jobnet: TemplateJobUtil.getTemplateJobList(false)){
				if(jobnet.getJobnetId().equals(jobId)){
					templateJob = jobnet;
				}
			}
			
			if(templateJob == null){
				throw new Exception("Target job doesn't exist.");
			}
		} catch (Exception e) {
			throw new IllegalStateException(e);
		}

		jobInfos = templateJob.getJobs();
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblTemplateId = new Label(container, SWT.NONE);
		lblTemplateId.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTemplateId.setText(bundle_dialog_label.getString("dialog.edit_template_job_argument.template_id_title"));
		
		txtTemplateId = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		txtTemplateId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		txtTemplateId.setText(templateId);
		
		Label lblJobnetId = new Label(container, SWT.NONE);
		lblJobnetId.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblJobnetId.setText(bundle_dialog_label.getString("dialog.edit_template_job_argument.jobnet_id_title"));
		
		txtJobnetId = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		txtJobnetId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		txtJobnetId.setText(jobId);
				
		table = new Table(container, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table.setBackground(SWTResourceManager.getColor(248, 248, 248));
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		TableColumn tblclmnJobId = new TableColumn(table, SWT.NONE);
		tblclmnJobId.setWidth(100);
		tblclmnJobId.setText(bundle_dialog_label.getString("dialog.edit_template_job_argument.column.job_id"));

		TableColumn tblclmnJobName = new TableColumn(table, SWT.NONE);
		tblclmnJobName.setWidth(141);
		tblclmnJobName.setText(bundle_dialog_label.getString("dialog.edit_template_job_argument.column.job_name"));
		
		TableColumn tblclmnCommand = new TableColumn(table, SWT.NONE);
		tblclmnCommand.setWidth(141);
		tblclmnCommand.setText(bundle_dialog_label.getString("dialog.edit_template_job_argument.column.execute_command"));
		
		TableColumn tblclmnUser = new TableColumn(table, SWT.NONE);
		tblclmnUser.setWidth(100);
		tblclmnUser.setText(bundle_dialog_label.getString("dialog.edit_template_job_argument.column.execute_user"));
		
		TableColumn tblclmnArgument = new TableColumn(table, SWT.NONE);
		tblclmnArgument.setWidth(100);
		tblclmnArgument.setText(bundle_dialog_label.getString("dialog.edit_template_job_argument.column.argument"));
		
		tableViewer = new TableViewer(table);

		String[] columnProperties = new String[]{"jobId","jobName","executeCommnad","executeUser","argument"};
		tableViewer.setColumnProperties(columnProperties);
		
		CellEditor[] editors = new CellEditor[]{
				new TextCellEditor(tableViewer.getTable()),
				new TextCellEditor(tableViewer.getTable()),
				new TextCellEditor(tableViewer.getTable()),
				new TextCellEditor(tableViewer.getTable()),
				new TextCellEditor(tableViewer.getTable())
		};
		tableViewer.setCellEditors(editors);
		tableViewer.setCellModifier(new ICellModifier(){
			@Override
			public boolean canModify(Object element, String property) {
				if(property.equals("argument")){
					Pattern pattern = Pattern.compile("\\#\\[" + CloudClientConstants.TEMPLATE_JOB_PARAMETER_PREFIX + ((TemplateJobUtil.TemplateJob)element).getJobId() + "\\]");
					Matcher matcher = pattern.matcher(((TemplateJobUtil.TemplateJob)element).getCommand());
					return matcher.find();
				}
				return false;
			}

			@Override
			public Object getValue(Object element, String property) {
				return ((TemplateJobUtil.TemplateJob)element).getArgument();
			}

			@Override
			public void modify(Object element, String property, Object value) {
				TemplateJobUtil.TemplateJob jobInfo = (TemplateJobUtil.TemplateJob)((TableItem)element).getData();
				jobInfo.setArgument((String)value);
				tableViewer.setInput(jobInfos);
			}
		});
		
		tableViewer.setContentProvider(new IStructuredContentProvider(){

			@Override
			public Object[] getElements(Object inputElement) {
				return ((java.util.List<?>)inputElement).toArray();
			}
			
			@Override
			public void dispose() {
				
			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
				
			}
		});
				
		tableViewer.setInput(jobInfos);
		tableViewer.setLabelProvider(new TableLabelProvider());
		
		for(TableItem item: table.getItems()){
			TemplateJobUtil.TemplateJob jobInfo = (TemplateJobUtil.TemplateJob)item.getData();
            Pattern pattern = Pattern.compile("\\#\\[" + CloudClientConstants.TEMPLATE_JOB_PARAMETER_PREFIX + jobInfo.getJobId() + "\\]");
            Matcher matcher = pattern.matcher(jobInfo.getCommand());
			if(matcher.find()){
				item.setBackground(4, SWTResourceManager.getColor(255, 255, 255));
			}
		}
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
//		if(this.volumes.isEmpty()){
//			MessageDialog.openError(null,
//					Messages.getString("failed"),
//					bundle_messages.getString("dialogs.must_fully_input"));
//			return;
//		}

		arguments.clear();
		
		for(TemplateJobUtil.TemplateJob jobInfo: jobInfos){
            Pattern pattern = Pattern.compile("\\#\\[" + CloudClientConstants.TEMPLATE_JOB_PARAMETER_PREFIX + jobInfo.getJobId() + "\\]");
            Matcher matcher = pattern.matcher(jobInfo.getCommand());
			if(matcher.find()){
				TemplateJobsArgument argument = new TemplateJobsArgument();
				argument.setJobId(jobInfo.getJobId());
				argument.setArg(jobInfo.getArgument());
				arguments.add(argument);
			}
		}
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("edit_template_job_argument"));
	}
	
	public List<TemplateJobsArgument> getArguments() {
		return arguments;
	}

	private static class TableLabelProvider extends LabelProvider implements ITableLabelProvider{

		@Override
		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}

		@Override
		public String getColumnText(Object element, int columnIndex) {
			TemplateJobUtil.TemplateJob jobInfo = (TemplateJobUtil.TemplateJob) element;
			switch(columnIndex){
			case 0:
				return jobInfo.getJobId();
			case 1:
				return jobInfo.getJobName();
			case 2:
				return jobInfo.getCommand();
			case 3:
				return jobInfo.getExecuteUser();
			case 4:
				return jobInfo.getArgument();
			}
			return null;
		}
	}
}
