/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.io.Serializable;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class CreateStorageDialog extends Dialog {
	public static class Decorator {
		private Combo control;
		
		private static ModifyListener modifyListener = new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				if(((Combo)e.getSource()).getText().equals("")){
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
			}
		};
		
		public Decorator(Combo control) {
			this.control = control;
			setEnabled(false);
		}
		
		public void setEnabled(boolean enable) {
			if (enable) {
				if (control.getText().equals("")) {
					control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				}
				else {
					control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
				control.addModifyListener(modifyListener);
			}
			else {
				control.removeModifyListener(modifyListener);
				control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
			}
		}
	}
	
	private static final int multiply = Integer.parseInt(MessageManager.getInstance("parameter").getString("aws.iops.multiply"));
	private static final int minIops = Integer.parseInt(MessageManager.getInstance("parameter").getString("aws.iops.miniops"));
	private static final int maxIops = Integer.parseInt(MessageManager.getInstance("parameter").getString("aws.iops.maxiops"));
	private static final int skip = Integer.parseInt(MessageManager.getInstance("parameter").getString("aws.iops.skip"));
	
	public static class Model extends CreateStorageRequest implements Serializable {
		private static final long serialVersionUID = -8364801407665470030L;
		public String region;

		public Model deepCopy() {
			return (Model)super.deepCopy();
		}
	}
	
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");
	private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");

	private static final String IOPS_VALUE = "io1";
	
	private Text volumeName;
	private Text size;
	private Combo unitSize;
	private Combo comboAvailabilityZone;
	private Combo comboSnapshot;
	private Combo volumeType;
	private Combo comboIops;
	private ControlDecoration ctdcIops;
	private ControlDecoration ctdcSize;
	private Label lblRegion;
	private Combo comboRegion;

	private CloudResourceProvider provider;

	private Model input;
	private Model output = new Model();

	private IDialogBehavior behavior;
	
	private Decorator decorator; 
	
	interface IDialogBehavior{
		void setInput(Model input);
		void setProvider(CloudResourceProvider provider);
		
		void setupVolumeName(Text volumeName);
		void setupSize(Text size, Combo unit);
		void setupRegion(Combo region);
		void setupAvailabilityZone(Combo availabilityZone);
		void setupSnapshot(Combo snapshot);
		void setupVolumeType(Combo volumeType);
		void setupIops(Combo Iops);
	}
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateStorageDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(4, false);
		gl_container.horizontalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblVolumeName = new Label(container, SWT.NONE);
		lblVolumeName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeName.setText(bundle_dialog_label.getString("dialog.create_storage.storage_name_title"));
		
		volumeName = new Text(container, SWT.BORDER);
		volumeName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblSize = new Label(container, SWT.NONE);
		lblSize.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSize.setText(bundle_dialog_label.getString("dialog.create_storage.storage_size_title"));
		
		size = new Text(container, SWT.BORDER);
		GridData gd_size = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_size.widthHint = 146;
		size.setLayoutData(gd_size);
		
		ctdcSize = new ControlDecoration(size, SWT.LEFT | SWT.TOP);
		ctdcSize.setImage(ResourceManager.getPluginImage(Activator.ID, "icons/error.gif"));
		ctdcSize.setDescriptionText("");
		ctdcSize.hide();
		
		unitSize = new Combo(container, SWT.READ_ONLY);
		GridData gd_unitSize = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_unitSize.widthHint = 124;
		unitSize.setLayoutData(gd_unitSize);
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		lblRegion = new Label(container, SWT.NONE);
		lblRegion.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblRegion.setText(bundle_dialog_label.getString("dialog.create_storage.region_title"));
		
		comboRegion = new Combo(container, SWT.READ_ONLY);
		comboRegion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblAvailabilityzone = new Label(container, SWT.NONE);
		lblAvailabilityzone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAvailabilityzone.setText(bundle_dialog_label.getString("dialog.create_storage.availability_zone_title"));
		
		comboAvailabilityZone = new Combo(container, SWT.READ_ONLY);
		comboAvailabilityZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblSnapshot = new Label(container, SWT.NONE);
		lblSnapshot.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSnapshot.setText(bundle_dialog_label.getString("dialog.create_storage.snapshot_title"));
		
		comboSnapshot = new Combo(container, SWT.READ_ONLY);
		GridData gd_snapshot = new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1);
		gd_snapshot.widthHint = 570;
		comboSnapshot.setLayoutData(gd_snapshot);
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblVolumeType = new Label(container, SWT.NONE);
		lblVolumeType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeType.setText(bundle_dialog_label.getString("dialog.create_storage.volume_type_title"));
		
		volumeType = new Combo(container, SWT.READ_ONLY);
		GridData gd_volumeType = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_volumeType.widthHint = 220;
		volumeType.setLayoutData(gd_volumeType);
		
		Label lblIops = new Label(container, SWT.NONE);
		lblIops.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblIops.setText(bundle_dialog_label.getString("dialog.create_storage.iops_title"));
		
		comboIops = new Combo(container, SWT.BORDER);
		GridData gd_iops = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_iops.widthHint = 208;
		comboIops.setLayoutData(gd_iops);
		
		ctdcIops = new ControlDecoration(comboIops, SWT.LEFT | SWT.TOP);
		ctdcIops.setImage(ResourceManager.getPluginImage(Activator.ID, "icons/error.gif"));
		ctdcIops.hide();

		unitSize.add("GiB");
		unitSize.add("TiB");
		unitSize.select(0);
		comboIops.setEnabled(false);

		behavior.setInput(input);
		behavior.setProvider(provider);
		
		behavior.setupVolumeName(volumeName);
		behavior.setupSize(size, unitSize);
		behavior.setupRegion(comboRegion);
		behavior.setupAvailabilityZone(comboAvailabilityZone);
		behavior.setupSnapshot(comboSnapshot);
		behavior.setupVolumeType(volumeType);
		behavior.setupIops(comboIops);
		
		size.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				if(!"".equals(size.getText())){
					String n = comboIops.getText();
					comboIops.removeAll();
					int iops = skip;
					while (iops <= maxIops) {
						comboIops.add(Integer.toString(iops));
						iops += skip;
					}
					comboIops.setText(n);
				}
			}
		});

		size.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent e) {
				try {
					String t = size.getText().substring(0, e.start) + e.text + size.getText().substring(e.start);
					if (t.length() != 0) {
						Integer.valueOf(t);
					}
				}
				catch(Exception e1) {
					e.doit = false;
				}
			}
		});
		
		size.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				checkIops();
			}
		});

		volumeType.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				if(volumeType.getText().equals(bundle_volume_type.getString(IOPS_VALUE))){
					comboIops.setEnabled(true);
					decorator.setEnabled(true);
				}
				else {
					decorator.setEnabled(false);
					comboIops.setEnabled(false);
				}
				checkIops();
			}
		});

		comboIops.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkIops();
			}
		});

		comboIops.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent e) {
				try {
					String t = comboIops.getText().substring(0, e.start) + e.text + comboIops.getText().substring(e.start);
					if (t.length() != 0) {
						Integer.valueOf(t);
					}
				}
				catch(Exception e1) {
					e.doit = false;
				}
			}
		});
		
		decorator = new Decorator(comboIops);
		ControlUtil.setRequired(new Control[]{volumeName, size});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if("".equals(volumeName.getText()) || "".equals(size.getText())){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}

		output = new Model();
		output.setStorageName(volumeName.getText());
		output.setStorageSize(Integer.parseInt(size.getText()));
		output.region = ((String)comboRegion.getData(comboRegion.getText()));
		output.setAvailabilityZone(comboAvailabilityZone.getText());
		output.setSnapshotId((String)comboSnapshot.getData(comboSnapshot.getText()));
		output.setStorageKind((String)volumeType.getData(volumeType.getText()));
		if (bundle_volume_type.getString(IOPS_VALUE).equals(volumeType.getText())) {
			output.setIops("".equals(comboIops.getText()) || comboIops.getText() == null ? null: Integer.parseInt(comboIops.getText()));
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("create_storage"));
	}

	public void checkIops(){
		if (bundle_volume_type.getString(IOPS_VALUE).equals(volumeType.getText()) &&
				((comboIops.getText().isEmpty() || Integer.parseInt(comboIops.getText()) < minIops || Integer.parseInt(comboIops.getText()) > maxIops))) {
			ctdcIops.show();
			ctdcIops.setShowHover(true);
			ctdcIops.setDescriptionText(bundle_messages.getString("dialogs.iops_must_be_less_than_20_times_of_volume_size", new String[]{Integer.toString(minIops), Integer.toString(maxIops)}));
			ctdcIops.showHoverText(bundle_messages.getString("dialogs.iops_must_be_less_than_20_times_of_volume_size", new String[]{Integer.toString(minIops), Integer.toString(maxIops)}));
		}
		else {
			ctdcIops.hide();
			ctdcIops.setDescriptionText("");
			ctdcIops.showHoverText("");
			ctdcIops.setShowHover(false);
		}

		if (bundle_volume_type.getString(IOPS_VALUE).equals(volumeType.getText()) &&
				((size.getText().isEmpty() && !comboIops.getText().isEmpty()) || (!size.getText().isEmpty() && !comboIops.getText().isEmpty() && Integer.parseInt(size.getText()) * multiply < Integer.parseInt(comboIops.getText())))) {
			ctdcSize.show();
			ctdcSize.setShowHover(true);
			ctdcSize.setDescriptionText(bundle_messages.getString("dialogs.must_grater_than_10", new String[]{Integer.toString(multiply)}));
			ctdcSize.showHoverText(bundle_messages.getString("dialogs.must_grater_than_10", new String[]{Integer.toString(multiply)}));
		}
		else {
			ctdcSize.hide();
			ctdcSize.setDescriptionText("");
			ctdcSize.showHoverText("");
			ctdcSize.setShowHover(false);
		}
	}

	public void setInput(Model input) {
		assert input != null;
		this.input = input;
	}

	public CreateStorageDialog.Model getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	public void setBehavior(IDialogBehavior behavior) {
		this.behavior = behavior;
	}
}
