/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class CreateStorageBackupDialog extends Dialog {
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private IStorage storage;
	
	private Text txtSnapshotName;
	private Text txtSnapshotDescription;
	private Text txtStorageId;
	
	private String snapshotName;
	private String snapshotDescription;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateStorageBackupDialog(Shell parentShell, IStorage storage) {
		super(parentShell);
		this.storage = storage;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		gl_container.horizontalSpacing = 16;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblStorageId = new Label(container, SWT.NONE);
		lblStorageId.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblStorageId.setText(bundle_dialog_label.getString("dialog.create_storage_backup.storage_id_title"));
		
		txtStorageId = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		txtStorageId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblName = new Label(container, SWT.NONE);
		lblName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblName.setText(bundle_dialog_label.getString("dialog.create_storage_backup.snapshot_name_title"));
		
		txtSnapshotName = new Text(container, SWT.BORDER);
		GridData gd_name = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_name.widthHint = 203;
		txtSnapshotName.setLayoutData(gd_name);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblDescription = new Label(container, SWT.NONE);
		lblDescription.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText(bundle_dialog_label.getString("dialog.create_storage_backup.description_title"));
		
		txtSnapshotDescription = new Text(container, SWT.BORDER);
		GridData gd_Description = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_Description.widthHint = 146;
		txtSnapshotDescription.setLayoutData(gd_Description);
		
		txtStorageId.setText(storage.getStorageId());
		

		ControlUtil.setRequired(new Control[]{txtSnapshotName});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if("".equals(txtSnapshotName.getText())){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}

		snapshotName = txtSnapshotName.getText();
		snapshotDescription = txtSnapshotDescription.getText();
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("backup_storage"));
	}

	public String getName() {
		return snapshotName;
	}

	public String getDescription() {
		return snapshotDescription;
	}
}
