/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.aws.presenter.IIpPermission;
import com.clustercontrol.cloud.commons.util.CloudClientConstants;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ParameterManager;
import com.clustercontrol.util.Messages;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

public class AddRuleDialog extends Dialog {
	private static final int INNER_WIDTH = 596;
	
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private ParameterManager protocolList = ParameterManager.getInstance(CloudClientConstants.PARAMETER_CONSTANTS_PARAMETER_IP_PERMISSION_PROTOCOL_LIST);
	private ParameterManager bundle_icmp = ParameterManager.getInstance(CloudClientConstants.PARAMETER_CONSTANTS_PARAMETER_IP_PERMISSION_ICMP_LIST);

	private Text protocol;
	private Text fromPort;
	private Text toPort;
	private Text source;
	private String returnProtocol;
	private String returnSecurityGroupId;
	private String returnUserId;
	private String returnGroupName;
	private String returnIpRange;
	private Integer returnFromPort;
	private Integer returnToPort;
	private IIpPermission ip;
	
	private Label lblPort;
	private Label lblPort2;
	
	private Combo template;
	private Combo icmp1;
	private Combo icmp2;

	private Map<String, String> serviceMap = new HashMap<String, String>();
	private Label lblService;
	private Label lblType;
	private Label lblCode;
	private Label lblSource;
	private Label lblSource2;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 * @wbp.parser.constructor
	 */
	public AddRuleDialog(Shell parentShell) {
		super(parentShell);
	}

	public AddRuleDialog(Shell parentShell, IIpPermission ip) {
		super(parentShell);
		this.ip = ip;
	}
	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		

		//幅調整用
		Group group = new Group(container, SWT.NONE);
		group.setLayout(new GridLayout(1, false));
		
		Label lblTemp = new Label(group, SWT.NONE);
		lblTemp.setText("");
		
		List<String> tmpList = new ArrayList<String>();
		tmpList.add(bundle_dialog_label.getString("dialog.add_rule.service_title"));
		tmpList.add(bundle_dialog_label.getString("dialog.add_rule.port_title"));
		tmpList.add(bundle_dialog_label.getString("dialog.add_rule.source_title"));
		tmpList.add(bundle_dialog_label.getString("dialog.add_rule.type_title"));
		tmpList.add(bundle_dialog_label.getString("dialog.add_rule.code_title"));
		
		Integer tmpWidth = 0;
		
		for(String str: tmpList){
			lblTemp.setText(str);
			lblTemp.getParent().layout();
			if(tmpWidth < lblTemp.getSize().x){
				tmpWidth = lblTemp.getSize().x;
			}
		}
		
		Integer portBridgeWidth;
		
		lblTemp.setText(bundle_dialog_label.getString("dialog.add_rule.port_bridge"));
		lblTemp.getParent().layout();
		
		portBridgeWidth = lblTemp.getSize().x;
		Integer portWidth = (INNER_WIDTH - tmpWidth - portBridgeWidth - 30) / 2;
		
		lblService = new Label(container, SWT.RIGHT);
		lblService.setBounds(0, 3, tmpWidth, 19);
		lblService.setAlignment(SWT.RIGHT);
		lblService.setText(bundle_dialog_label.getString("dialog.add_rule.service_title"));
		
		template = new Combo(container, SWT.NONE);
		template.setBounds(tmpWidth + 10, 0, INNER_WIDTH - tmpWidth -10, 25);
		
		lblPort = new Label(container, SWT.NONE);
		lblPort.setBounds(0, 3, tmpWidth, 19);
		lblPort.setAlignment(SWT.RIGHT);
		lblPort.setText(bundle_dialog_label.getString("dialog.add_rule.port_title"));
		
		fromPort = new Text(container, SWT.BORDER);
		fromPort.setBounds(tmpWidth + 10, 0, portWidth, 25);
		fromPort.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_HIGHLIGHT_SHADOW));
		
		fromPort.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				if (!(((e.keyCode >= '0' && e.keyCode <= '9') && e.stateMask == 0) || ((e.keyCode >= 16777264 && e.keyCode <= 16777273) && e.stateMask == 0) || checkKey(e.keyCode))) {
					e.doit = false;
				}
			}
		});
		
		lblPort2 = new Label(container, SWT.NONE);
		lblPort2.setBounds(tmpWidth + portWidth + 20, 3, portBridgeWidth, 19);
		lblPort2.setText(bundle_dialog_label.getString("dialog.add_rule.port_bridge"));
		
		toPort = new Text(container, SWT.BORDER);
		toPort.setBounds(tmpWidth + portWidth + portBridgeWidth + 30, 0, portWidth, 25);
		
		toPort.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				if (!(((e.keyCode >= '0' && e.keyCode <= '9') && e.stateMask == 0) || ((e.keyCode >= 16777264 && e.keyCode <= 16777273) && e.stateMask == 0) || checkKey(e.keyCode))) {
					e.doit = false;
				}
			}
		});
		
		protocol = new Text(container, SWT.BORDER);
		protocol.setVisible(false);
		
		lblSource = new Label(container, SWT.NONE);
		lblSource.setBounds(0, 3, tmpWidth, 19);
		lblSource.setAlignment(SWT.RIGHT);
		lblSource.setText(bundle_dialog_label.getString("dialog.add_rule.source_title"));
		
		source = new Text(container, SWT.BORDER);
		source.setBounds(tmpWidth + 10, 0, INNER_WIDTH - tmpWidth -10, 25);
		source.setEnabled(true);
		
		lblSource2 = new Label(container, SWT.HORIZONTAL);
		lblSource2.setBounds(tmpWidth + 10, 3, INNER_WIDTH - tmpWidth -10, 19);
		lblSource2.setText(bundle_dialog_label.getString("dialog.add_rule.source_example"));
		
		icmp2 = new Combo(container, SWT.NONE);
		icmp2.setBounds(tmpWidth + 10, 0, INNER_WIDTH - tmpWidth -10, 25);
		icmp2.setEnabled(false);
		
		icmp1 = new Combo(container, SWT.NONE);
		icmp1.setBounds(tmpWidth + 10, 0, INNER_WIDTH - tmpWidth -10, 25);
		icmp1.setEnabled(false);
		
		lblType = new Label(container, SWT.NONE);
		lblType.setBounds(0, 3, tmpWidth, 19);
		lblType.setText(bundle_dialog_label.getString("dialog.add_rule.type_title"));
		lblType.setAlignment(SWT.RIGHT);
		
		lblCode = new Label(container, SWT.NONE);
		lblCode.setBounds(0, 3, tmpWidth, 19);
		lblCode.setText(bundle_dialog_label.getString("dialog.add_rule.code_title"));
		lblCode.setAlignment(SWT.RIGHT);

		for(Map.Entry<String, String> entry: protocolList.getMap().entrySet()){
			template.add(entry.getKey());
			template.setData(entry.getKey(), entry.getValue());
			
			Map<String, String> map = ParameterManager.getInstance(entry.getValue()).getMap();
			
			serviceMap.put(map.get("protocol") + "," +  map.get("fromPort") + "," + map.get("toPort"), entry.getKey());
		}

		for(Map.Entry<String, String> entry : bundle_icmp.getMap().entrySet()){
			icmp1.add(entry.getKey());
			icmp1.setData(entry.getKey(), entry.getValue());
		}
		
		icmp1.setEnabled(false);
		icmp2.setEnabled(false);


		updateLayout();

		if(ip != null){
			String title = serviceMap.get(ip.getIpProtocol() + "," + String.valueOf(ip.getFromPort()) + "," + String.valueOf(ip.getToPort()));
			
			if(title == null){
				title = serviceMap.get(ip.getIpProtocol() + ",,");
			}

			template.select(template.indexOf(title));
			
			protocolSelected((String)template.getData(title));
			
			if(icmp1.isEnabled()){
				icmp1.select(icmp1.indexOf(bundle_icmp.getReverseMap().get(String.valueOf(ip.getFromPort()))));
				icmpSelected(icmp1.getText());
			}
			
			if(icmp2.isEnabled()){
				icmp2.select(icmp2.indexOf(ParameterManager.getInstance(icmp1.getText()).getReverseMap().get(String.valueOf(ip.getToPort()))));
			}

			protocol.setText(ip.getIpProtocol());
			if(ip.getFromPort() == ip.getToPort()){
				fromPort.setText(String.valueOf(ip.getFromPort()));
			} else {
				fromPort.setText(String.valueOf(ip.getFromPort()));
				toPort.setText(String.valueOf(ip.getToPort()));
			}
			
			if(ip.getIpRange() == null || "".equals(ip.getIpRange())){
				source.setText(ip.getSecurityGroupId());
			} else {
				source.setText(ip.getIpRange());
			}
		}
		
		template.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				AddRuleDialog.this.protocolSelected(protocolList.getValue(((Combo)e.getSource()).getText()));
			}
		});
		
		icmp1.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				AddRuleDialog.this.icmpSelected(((Combo)e.getSource()).getText());
			}
		});

		icmp2.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				toPort.setText((String)((Combo)e.getSource()).getData(((Combo)e.getSource()).getText()));
			}
		});
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if("".equals(protocol.getText()) || ("".equals(fromPort.getText()) && "".equals(toPort.getText())) || "".equals(source.getText())){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}
		
		if(isCidr(source.getText())){
			returnIpRange = source.getText();
		} else if(isSecurityGroupId(source.getText())){
			returnSecurityGroupId = source.getText();
		} else if(isUserIdGroupNamePair(source.getText())){
			returnUserId = source.getText().substring(0, 12);
			returnGroupName = source.getText().substring(13).trim();
		} else {
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_input_matched_string"));
			return;
		}
		
		if("".equals(fromPort.getText())){
			fromPort.setText(toPort.getText());
		} else if("".equals(toPort.getText())){
			toPort.setText(fromPort.getText());
		}
		
		returnProtocol = protocol.getText();
		returnFromPort = Integer.parseInt(fromPort.getText());
		returnToPort = Integer.parseInt(toPort.getText());
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		if(ip == null){
			newShell.setText(bundle_dialog_name.getString("add_rule"));
		} else {
			newShell.setText(bundle_dialog_name.getString("edit_rule"));
		}
	}
	
	private static boolean isCidr(String str){
		Pattern p = Pattern.compile("^([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])(\\.([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){3}/[0-9]{1,2}$");
		return p.matcher(str).find();
	}

	private static boolean isSecurityGroupId(String str){
		Pattern p = Pattern.compile("^sg-[a-f0-9]{8}$");
		return p.matcher(str).find();
	}

	private static boolean isUserIdGroupNamePair(String str){
		Pattern p = Pattern.compile("^[0-9]{12}/.+$");
		return p.matcher(str).find();
	}
	
	private static boolean checkKey(int keyCode) {
		int[] keys = {
		SWT.SHIFT, // （[Shift]キー）
		SWT.ALT, // （[Alt]キー）
		SWT.ARROW_DOWN, // （[↓]キー）
		SWT.ARROW_LEFT, // （[←]キー）
		SWT.ARROW_RIGHT, // （[→]キー）
		SWT.ARROW_UP, // （[↑]キー）
		SWT.BS, // （[BackSpace]キー）
		SWT.CONTROL, //
		SWT.CTRL, // （[Ctrl]キー）
		SWT.DEL, // （[Delete]キー）
		SWT.ESC, // （[Esc]キー）
		SWT.F1, // - SWT.F12 （ファンクションキー）
		SWT.F2, // - SWT.F12 （ファンクションキー）
		SWT.F3, // - SWT.F12 （ファンクションキー）
		SWT.F4, // - SWT.F12 （ファンクションキー）
		SWT.F5, // - SWT.F12 （ファンクションキー）
		SWT.F6, // - SWT.F12 （ファンクションキー）
		SWT.F7, // - SWT.F12 （ファンクションキー）
		SWT.F8, // - SWT.F12 （ファンクションキー）
		SWT.F9, // - SWT.F12 （ファンクションキー）
		SWT.F10, // - SWT.F12 （ファンクションキー）
		SWT.F11, // - SWT.F12 （ファンクションキー）
		SWT.F12, // - SWT.F12 （ファンクションキー）
		};

		for (int key: keys) {
			if (keyCode == key) {
				return true;
			}
		}

		return false;
	}

	public String getIpProtocol() {
		return returnProtocol;
	}

	public String getSecurityGroupId() {
		return returnSecurityGroupId;
	}

	public String getUserId() {
		return returnUserId;
	}
	
	public String getGroupName() {
		return returnGroupName;
	}
	
	public String getIpRange() {
		return returnIpRange;
	}

	public Integer getFromPort() {
		return returnFromPort;
	}

	public Integer getToPort() {
		return returnToPort;
	}
	
	private void protocolSelected(String selection){
		Map<String, String> map = ParameterManager.getInstance(selection).getMap();

		protocol.setText(map.get("protocol"));
		protocol.setEnabled(false);
		
		if("icmp".equals(map.get("protocol"))) {
			icmp1.setEnabled(true);
			fromPort.setEnabled(false);
			toPort.setEnabled(false);
			if(!"".equals(map.get("fromPort"))){
				icmp1.select(icmp1.indexOf(bundle_icmp.getReverseMap().get(map.get("fromPort"))));
				icmp1.setEnabled(false);
				fromPort.setText(map.get("fromPort"));
				icmpSelected(icmp1.getText());
			}
		} else {
			icmp2.removeAll();
			icmp1.setEnabled(false);
			icmp2.setEnabled(false);

			if(!"".equals(map.get("fromPort"))){
				fromPort.setText(map.get("fromPort"));
				fromPort.setEnabled(false);
			} else {
				fromPort.setEnabled(true);
			}
			if(!"".equals(map.get("toPort"))){
				toPort.setText(map.get("toPort"));
				toPort.setEnabled(false);
			} else {
				toPort.setEnabled(true);
			}
		}

		updateLayout();
	}

	private void icmpSelected(String selection){
		Map<String, String> map = ParameterManager.getInstance(selection).getMap();

		if(map.size() > 1){
			icmp2.removeAll();
			for(Map.Entry<String, String> entry: ParameterManager.getInstance(selection).getMap().entrySet()){
				icmp2.add(entry.getKey());
				icmp2.setData(entry.getKey(), entry.getValue());
			}
			icmp2.select(0);
			toPort.setText((String)icmp2.getData(icmp2.getText()));
			icmp2.setEnabled(true);
		} else {
			for(String value: map.values()){
				toPort.setText(value);
			}
			icmp2.setEnabled(false);
		}

		updateLayout();
	}
	
	private void updateLayout(){
		int row = 0;
		
		if(template.isEnabled()){
			enableControl(lblService, row, 3);
			enableControl(template, row, 0);
			row++;
		} else {
			lblService.setVisible(false);
			lblService.setVisible(false);
		}

		if(fromPort.isEnabled() && toPort.isEnabled()){
			enableControl(lblPort, row, 3);
			enableControl(lblPort2, row, 3);
			enableControl(fromPort, row, 0);
			enableControl(toPort, row, 0);
			row++;
		} else {
			lblPort.setVisible(false);
			lblPort2.setVisible(false);
			fromPort.setVisible(false);
			toPort.setVisible(false);
		}

		if(icmp1.isEnabled()){
			enableControl(lblType, row, 3);
			enableControl(icmp1, row, 0);
			row++;
		} else {
			lblType.setVisible(false);
			icmp1.setVisible(false);
		}

		if(icmp2.isEnabled()){
			enableControl(lblCode, row, 3);
			enableControl(icmp2, row, 0);
			row++;
		} else {
			lblCode.setVisible(false);
			icmp2.setVisible(false);
		}
		
		if(source.isEnabled()){
			enableControl(lblSource, row, 3);
			enableControl(lblSource2, row, 28);
			enableControl(source, row, 0);
			row++;
		} else {
			lblSource.setVisible(false);
			lblSource2.setVisible(false);
			source.setVisible(false);
		}
		
	}
	
	private void enableControl(Control c, int row, int offset){
		final int UNIT = 25;
		int y = row * UNIT * 2 + offset;
		c.setBounds(c.getBounds().x, y, c.getBounds().width, c.getBounds().height);
		c.setVisible(true);
	}
}
