/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.clustercontrol.repository.bean.FacilityConstant;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.repository.RepositoryEndpoint;

/**
 */
public class WrappedFacilityTreeItem {
	private List<WrappedFacilityTreeItem> children;
    private FacilityInfo data;
    private FacilityTreeItem facilityTreeItem;
    private WrappedFacilityTreeItem parent;
    private RepositoryEndpoint endpoint;

    private Map<String, FacilityInfo> nodeMap;

    public WrappedFacilityTreeItem(WrappedFacilityTreeItem parent, FacilityTreeItem facilityTreeItem, RepositoryEndpoint endpoint) {
    	super();
    	assert facilityTreeItem != null;

    	this.parent = parent;
    	this.facilityTreeItem = facilityTreeItem;
    	this.endpoint = endpoint;
    }

    public List<WrappedFacilityTreeItem> getChildren() {
    	if (children == null) {
    		children = new ArrayList<WrappedFacilityTreeItem>();

    		for (FacilityTreeItem child: facilityTreeItem.getChildren()) {
    			children.add(new WrappedFacilityTreeItem(this, child, endpoint));
    		}
    	}

    	return children;
    }

    public FacilityInfo getData() {
    	if (data == null) {
    		switch (facilityTreeItem.getData().getFacilityType()) {
    		case FacilityConstant.TYPE_SCOPE:
    			data = facilityTreeItem.getData();
		    	break;
    		case FacilityConstant.TYPE_NODE:
    			FacilityInfo fi = facilityTreeItem.getData();
    			data = getNodeMap().get(fi.getFacilityId());
    			if (data == null) {
    		    	try {
						data = endpoint.getNode(facilityTreeItem.getData().getFacilityId());
	        			getNodeMap().put(fi.getFacilityId(), data);
					}
    		    	catch (Exception e) {
						Logger logger = Logger.getLogger(WrappedFacilityTreeItem.class);
						logger.warn("faild to get NodeInfo of " + fi.getFacilityId() + ".");
					}
    			}
		    	break;
    		default:
    			data = facilityTreeItem.getData();
    		}
    	}

        return data;
    }

    public WrappedFacilityTreeItem getParent() {
        return parent;
    }
    
    protected Map<String, FacilityInfo> getNodeMap() {
    	Map<String, FacilityInfo> lnodeMap;
    	
    	if (parent == null) {
    		if (nodeMap == null) {
        		nodeMap = new HashMap<String, FacilityInfo>();
    		}
    		
    		lnodeMap = nodeMap;
    	}
    	else {
    		lnodeMap = parent.getNodeMap();
    	}
    	
    	return lnodeMap;
    }
}