/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;


public interface ValueObserver2<P> extends PropertyObserver2<P> {
	public class ValueChangedEvent<P> extends PropEvent<P, ValueObserver2<P>> {
		private P newValue;
		private P oldValue;
		public ValueChangedEvent(Object source, PropertyId2<ValueObserver2<P>> pid, P newValue, P oldValue) {
			super(source, pid);
			this.newValue = newValue;
			this.oldValue = oldValue;
		}
		public P getNewValue() {
			return newValue;
		}
		public P getOldValue() {
			return oldValue;
		}
		@Override
		public void dispatch(ValueObserver2<P> observer) {
			if ((getNewValue() != null && !getNewValue().equals(getOldValue())) || getNewValue() != getOldValue()) {
				observer.propertyChanged(this);
			}
		}
	}
	void propertyChanged(ValueChangedEvent<P> event);
}