/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudStorageBackup;

public class StorageBackupRoot extends Element implements IStorageBackupRoot {
	private BackupManagement backupManagement;
	private List<StorageBackup> storageBackups;

	public StorageBackupRoot(BackupManagement backupManagement) {
		this.backupManagement = backupManagement;
	}	

	@Override
	public void update() throws CloudModelException {
		List<CloudStorageBackup> cloudStorageBackup = Collections.emptyList();

		try {
			CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			cloudStorageBackup = endpoint.getStorageBackupsByRegion(getBackupManagement().getRegion().getRegionName());
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}

		internalUpdate(cloudStorageBackup);

		super.update();
	}
	
	public boolean isInitialized() {
		return storageBackups != null;
	}
	
	private List<StorageBackup> getStorageBackupsList() {
		if (!isInitialized()) {
			update();
		}
		return storageBackups;
	}
	
	public void internalUpdate(List<CloudStorageBackup> cloudInstancesBackups) throws CloudModelException {
		if (isInitialized()) {
			List<StorageBackup> instancesBackupsTemp = new ArrayList<StorageBackup>(storageBackups);
			List<CloudStorageBackup> cloudStorageBackupsTemp = new ArrayList<CloudStorageBackup>(cloudInstancesBackups);
			Iterator<CloudStorageBackup> cloudStorageBackupsIter = cloudStorageBackupsTemp.iterator();
			while (cloudStorageBackupsIter.hasNext()) {
				CloudStorageBackup csb = cloudStorageBackupsIter.next();
				
				Iterator<StorageBackup> StorageBackupsIter = instancesBackupsTemp.iterator();
				while (StorageBackupsIter.hasNext()) {
					StorageBackup s = StorageBackupsIter.next();
					
					if (csb.getSnapshotId().equals(s.getSnapshotId()) && getBackupManagement().getRegion().getRegionName().equals(csb.getRegion())) {
						s.internalUpdate(csb);

						StorageBackupsIter.remove();
						cloudStorageBackupsIter.remove();
						break;
					}
				}
			}

			for (StorageBackup i: instancesBackupsTemp) {
				getStorageBackupsList().remove(i);
				fireElementRemoved(p2.storageBackups, i);
			}

			for (CloudStorageBackup cib: cloudStorageBackupsTemp) {
				StorageBackup newStorageBackup = StorageBackup.createStorageBackup(this, cib);
				getStorageBackupsList().add(newStorageBackup);
				this.fireElementAdded(p2.storageBackups, newStorageBackup);
			}
		}
		else {
			List<StorageBackup> tempStorageBackups = new ArrayList<StorageBackup>();
			for (CloudStorageBackup storageBackup: cloudInstancesBackups) {
				tempStorageBackups.add(StorageBackup.createStorageBackup(this, storageBackup));
			}
			storageBackups = tempStorageBackups;
		}
	}

	@Override
	public BackupManagement getBackupManagement() {
		return backupManagement;
	}

	@Override
	public StorageBackup[] getStorageBackups() {
		return getStorageBackupsList().toArray(new StorageBackup[0]);
	}

	@Override
	public CloudResourceManager getCloudResourceManager() {
		return backupManagement.getCloudResourceManager();
	}

	public IStorageBackup getStorageBackup(String snapshotId) {
		for(IStorageBackup backup: getStorageBackupsList()){
			if(backup.getSnapshotId().equals(snapshotId)){
				return backup;
			}
		}
		return null;
	}

	@Override
	public IStorageBackup createStorageBackup(CreateStorageBackupRequest request) {
		com.clustercontrol.ws.cloud.CreateStorageBackupRequest wsRequest = new com.clustercontrol.ws.cloud.CreateStorageBackupRequest();
		wsRequest.setSnapshotName(request.getSnapshotName());
		wsRequest.setRegionName(request.getRegion());
		wsRequest.setStorageId(request.getStorageId());
		wsRequest.setSnapshotName(request.getSnapshotName());
		wsRequest.setDescription(request.getDescription());

		try {
			CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			CloudStorageBackup backup = endpoint.addStorageBackup(wsRequest);

			StorageBackup newBackup = StorageBackup.createStorageBackup(this, backup);
			getStorageBackupsList().add(newBackup);
			fireElementAdded(StorageBackupRoot.p2.storageBackups, newBackup);
			return newBackup;
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void deleteStorageBackup(String snapshotId) {
		try {
			CloudEndpoint endpoint = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			endpoint.removeStorageBackup(backupManagement.getRegion().getRegionName(), snapshotId);
			
			IStorageBackup removeBackup = getStorageBackup(snapshotId);
			getStorageBackupsList().remove(removeBackup);
			fireElementRemoved(StorageBackupRoot.p2.storageBackups, removeBackup);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
}
